#include <stdlib.h>
#include <stdio.h>

#include "vkeyboardusb_intern.h"

usbkeydef_t usbkeydef_defaults[KEYDEF_USB_MAX] = {
    {   0,  USB_KEY_TYPE_NORMAL, 0x35 }, /* ~		*/
    {   1,  USB_KEY_TYPE_NORMAL, 0x1e }, /* 1		*/
    {   2,  USB_KEY_TYPE_NORMAL, 0x1f }, /* 2		*/
    {   3,  USB_KEY_TYPE_NORMAL, 0x20 }, /* 3		*/
    {   4,  USB_KEY_TYPE_NORMAL, 0x21 }, /* 4		*/
    {   5,  USB_KEY_TYPE_NORMAL, 0x22 }, /* 5		*/
    {   6,  USB_KEY_TYPE_NORMAL, 0x23 }, /* 6		*/
    {   7,  USB_KEY_TYPE_NORMAL, 0x24 }, /* 7		*/
    {   8,  USB_KEY_TYPE_NORMAL, 0x25 }, /* 8		*/
    {   9,  USB_KEY_TYPE_NORMAL, 0x26 }, /* 9		*/
    {  10,  USB_KEY_TYPE_NORMAL, 0x27 }, /* 0		*/
    {  11,  USB_KEY_TYPE_NORMAL, 0x2d }, /* -		*/
    {  12,  USB_KEY_TYPE_NORMAL, 0x2e }, /* =		*/
    {  13,  USB_KEY_TYPE_NORMAL, 0x2a }, /* <-		*/
    {  14,  USB_KEY_TYPE_NORMAL, 0x2b }, /* TAB		*/
    {  15,  USB_KEY_TYPE_NORMAL, 0x14 }, /* Q		*/
    {  16,  USB_KEY_TYPE_NORMAL, 0x1a }, /* W		*/
    {  17,  USB_KEY_TYPE_NORMAL, 0x08 }, /* E		*/
    {  18,  USB_KEY_TYPE_NORMAL, 0x15 }, /* R		*/
    {  19,  USB_KEY_TYPE_NORMAL, 0x17 }, /* T		*/
    {  20,  USB_KEY_TYPE_NORMAL, 0x1c }, /* Y		*/
    {  21,  USB_KEY_TYPE_NORMAL, 0x18 }, /* U		*/
    {  22,  USB_KEY_TYPE_NORMAL, 0x0C }, /* I		*/
    {  23,  USB_KEY_TYPE_NORMAL, 0x12 }, /* O		*/
    {  24,  USB_KEY_TYPE_NORMAL, 0x13 }, /* P		*/
    {  25,  USB_KEY_TYPE_NORMAL, 0x2f }, /* {,[		*/
    {  26,  USB_KEY_TYPE_NORMAL, 0x30 }, /* },]		*/
    {  27,  USB_KEY_TYPE_NORMAL, 0x28 }, /* ENTER	*/
    {  28,  USB_KEY_TYPE_NORMAL, 0x39 }, /* CAPS	*/
    {  29,  USB_KEY_TYPE_NORMAL, 0x04 }, /* A		*/
    {  30,  USB_KEY_TYPE_NORMAL, 0x16 }, /* S		*/
    {  31,  USB_KEY_TYPE_NORMAL, 0x07 }, /* D		*/
    {  32,  USB_KEY_TYPE_NORMAL, 0x09 }, /* F		*/
    {  33,  USB_KEY_TYPE_NORMAL, 0x0a }, /* G		*/
    {  34,  USB_KEY_TYPE_NORMAL, 0x0b }, /* H		*/
    {  35,  USB_KEY_TYPE_NORMAL, 0x0d }, /* J		*/
    {  36,  USB_KEY_TYPE_NORMAL, 0x0e }, /* K		*/
    {  37,  USB_KEY_TYPE_NORMAL, 0x0f }, /* L		*/
    {  38,  USB_KEY_TYPE_NORMAL, 0x33 }, /* ;		*/
    {  39,  USB_KEY_TYPE_NORMAL, 0x34 }, /* '		*/
    {  40,  USB_KEY_TYPE_NORMAL, 0x32 }, /* \		*/ /* */
    {  41,  USB_KEY_TYPE_MODIFIER, 0xe1 }, /* LSHIFT	*/
    {  42,  USB_KEY_TYPE_NORMAL, 0x64 }, /* \		*/
    {  43,  USB_KEY_TYPE_NORMAL, 0x1d }, /* Z		*/
    {  44,  USB_KEY_TYPE_NORMAL, 0x1b }, /* X		*/
    {  45,  USB_KEY_TYPE_NORMAL, 0x06 }, /* C		*/
    {  46,  USB_KEY_TYPE_NORMAL, 0x19 }, /* V		*/
    {  47,  USB_KEY_TYPE_NORMAL, 0x05 }, /* B		*/
    {  48,  USB_KEY_TYPE_NORMAL, 0x11 }, /* N		*/
    {  49,  USB_KEY_TYPE_NORMAL, 0x10 }, /* M		*/
    {  50,  USB_KEY_TYPE_NORMAL, 0x36 }, /* ,		*/
    {  51,  USB_KEY_TYPE_NORMAL, 0x37 }, /* .		*/
    {  52,  USB_KEY_TYPE_NORMAL, 0x38 }, /* /		*/
    {  53,  USB_KEY_TYPE_MODIFIER, 0xe5 }, /* RSHIFT	*/
    {  54,  USB_KEY_TYPE_MODIFIER, 0xe0 }, /* LCTRL	*/
    {  55,  USB_KEY_TYPE_MODIFIER, 0xe2 }, /* LALT	*/
    {  56,  USB_KEY_TYPE_NORMAL, 0x2c }, /* SPACE	*/
    {  57,  USB_KEY_TYPE_MODIFIER, 0xe6 }, /* RALT	*/
    {  58,  USB_KEY_TYPE_MODIFIER, 0xe4 }, /* RCTRL	*/
    {  59,  USB_KEY_TYPE_NORMAL, 0x29 }, /* ESC		*/
    {  60,  USB_KEY_TYPE_NORMAL, 0x3a }, /* F1		*/
    {  61,  USB_KEY_TYPE_NORMAL, 0x3b }, /* F2		*/
    {  62,  USB_KEY_TYPE_NORMAL, 0x3c }, /* F3		*/
    {  63,  USB_KEY_TYPE_NORMAL, 0x3d }, /* F4		*/
    {  64,  USB_KEY_TYPE_NORMAL, 0x3e }, /* F5		*/
    {  65,  USB_KEY_TYPE_NORMAL, 0x3f }, /* F6		*/
    {  66,  USB_KEY_TYPE_NORMAL, 0x40 }, /* F7		*/
    {  67,  USB_KEY_TYPE_NORMAL, 0x41 }, /* F8		*/
    {  68,  USB_KEY_TYPE_NORMAL, 0x42 }, /* F9		*/
    {  69,  USB_KEY_TYPE_NORMAL, 0x43 }, /* F10		*/
    {  70,  USB_KEY_TYPE_NORMAL, 0x44 }, /* F11		*/
    {  71,  USB_KEY_TYPE_NORMAL, 0x45 }, /* F12		*/
    {  72,  USB_KEY_TYPE_NORMAL, 0x46 }, /* PRINTSCREEN	*/
    {  73,  USB_KEY_TYPE_NORMAL, 0x47 }, /* SCROLL LOCK	*/
    {  74,  USB_KEY_TYPE_NORMAL, 0x48 }, /* PAUSE	*/
    {  75,  USB_KEY_TYPE_NORMAL, 0x49 }, /* INSERT	*/
    {  76,  USB_KEY_TYPE_NORMAL, 0x4a }, /* HOME	*/
    {  77,  USB_KEY_TYPE_NORMAL, 0x4b }, /* PAGE UP	*/
    {  78,  USB_KEY_TYPE_NORMAL, 0x4c }, /* DELETE	*/
    {  79,  USB_KEY_TYPE_NORMAL, 0x4d }, /* END		*/
    {  80,  USB_KEY_TYPE_NORMAL, 0x4e }, /* PAGE DOWN	*/

    {  81,  USB_KEY_TYPE_NORMAL, 0x52 }, /* UP		*/
    {  82,  USB_KEY_TYPE_NORMAL, 0x50 }, /* LEFT	*/
    {  83,  USB_KEY_TYPE_NORMAL, 0x51 }, /* DOWN	*/
    {  84,  USB_KEY_TYPE_NORMAL, 0x4f }, /* RIGHT	*/

    {  85,  USB_KEY_TYPE_NORMAL, 0x53 }, /* NUMLOCK	*/
    {  86,  USB_KEY_TYPE_NORMAL, 0x5f }, /* NUM 7	*/
    {  87,  USB_KEY_TYPE_NORMAL, 0x60 }, /* NUM 8	*/
    {  88,  USB_KEY_TYPE_NORMAL, 0x61 }, /* NUM 9	*/
    {  89,  USB_KEY_TYPE_NORMAL, 0x57 }, /* NUM +	*/
    {  90,  USB_KEY_TYPE_NORMAL, 0x54 }, /* NUM /	*/
    {  91,  USB_KEY_TYPE_NORMAL, 0x5c }, /* NUM 4	*/
    {  92,  USB_KEY_TYPE_NORMAL, 0x5d }, /* NUM 5	*/
    {  93,  USB_KEY_TYPE_NORMAL, 0x5e }, /* NUM 6	*/
    {  94,  USB_KEY_TYPE_NORMAL, 0x55 }, /* NUM *	*/
    {  95,  USB_KEY_TYPE_NORMAL, 0x59 }, /* NUM 1	*/
    {  96,  USB_KEY_TYPE_NORMAL, 0x5a }, /* NUM 2	*/
    {  97,  USB_KEY_TYPE_NORMAL, 0x5b }, /* NUM 3	*/
    {  98,  USB_KEY_TYPE_NORMAL, 0x58 }, /* NUM RET	*/
    {  99,  USB_KEY_TYPE_NORMAL, 0x56 }, /* NUM -	*/
    { 100,  USB_KEY_TYPE_NORMAL, 0x62 }, /* NUM 0	*/
    { 101,  USB_KEY_TYPE_NORMAL, 0x63 }, /* NUM .	*/

    { 102,  USB_KEY_TYPE_NORMAL, 0x48 }, /* BREAK (Ctrl+Pause)	*/
    	/* in USB keyboards, the Ctrl+Pause combination really sends pause,
    	   not ScrollLock like in PS/2 keyboards */
    	   
    { 103,  USB_KEY_TYPE_NORMAL, 0xe3 }, /* Dummy	*/
    { 104,  USB_KEY_TYPE_NORMAL, 0xe3 }, /* Dummy	*/

    { 105,  USB_KEY_TYPE_MODIFIER, 0xe3 }, /* LWIN	*/
    { 106,  USB_KEY_TYPE_NORMAL, 0x65 }, /* MENU	*/
    { 107,  USB_KEY_TYPE_MODIFIER, 0xe7 }  /* RWIN	*/
};

