#ifndef _PP_KVM_H
#define _PP_KVM_H

/* public functions of libpp_kvm */

/* firmware includes */
#include <pp/vector.h>
#include <pp/base.h>
#include <liberic_session.h>
#include <pp/kvmdefs.h>

#if defined(__cplusplus)
#define EXTERN_C extern "C"
#else
#define EXTERN_C extern
#endif

//typedef const struct pp_kvm_link_client_s *pp_kvm_link_client_t;
typedef struct pp_kvm_link_client_s *pp_kvm_link_client_t;

typedef enum {
    PP_KVM_LOCAL,
    PP_KVM_REMOTE,
    PP_KVM_DUMMY,
} pp_kvm_session_type_t;
/**
 * Encoder callback structure. Defines callbacks that the encoder
 * must provide to connect to the kvm. Callbacks may be NULL.
 */
typedef struct {
    /**
     * Send a KVM switch event to a forensic encoder
     */
    void (*encoder_send_kvm_switch_event)(eric_session_int_id_t session,
					  unsigned char channel, unsigned char unit,
					  unsigned short port);
} pp_kvm_encoder_desc_t;


#ifdef PRODUCT_RIPCKIMXN
# define PP_KVM_CHANNEL_COUNT	2
#else
# define PP_KVM_CHANNEL_COUNT	1
#endif

/* max. number of channels any kvm switch supports */
#define PP_KVM_MAX_CHANNEL_COUNT	16

/* max. number of supported kvm switch units */
#define PP_KVM_MAX_UNIT_COUNT		16

/* max. number of supported ports in one kvm switch unit */
#define PP_KVM_MAX_UNIT_PORT_COUNT	64

/* init function */
EXTERN_C int pp_kvm_init(void);

/* connect an encoder */
EXTERN_C int pp_kvm_connect_encoder(pp_kvm_encoder_desc_t* encoder);

/* cleanup function */
extern void pp_kvm_cleanup(void);

/* these function was added for the RIPC board */
/* tells the kvm lib that a port has changed
 *     CONTROL: 1 if console is now in control of new host, 0 if only viewing */
extern void pp_kvm_port_changed(u_char channel, u_char old_unit, u_char old_port,
				u_char new_unit, u_char new_port, u_char control);

/* Tells the kvm lib to enable/disable passing through the video of CHANNEL
 * to the local console port of the kvm switch.
 *     - see: Belkin RIPC USB spec, 4.2.2 (console device change message)
 */
extern void pp_kvm_set_local_video_state(u_char channel, int status);

/* tells the kvm lib that the kvm switch would beep if you can hear it ;-) */
extern void pp_kvm_console_beep(u_char channel, u_short pitch, u_char _time);

/* tells the kvm lib that the kvm switch has entered autoscan mode */
extern void pp_kvm_autoscan(u_char channel, int status);

/* tells the kvm lib that the ip of the device has changed via OSD of kvm switch */
extern void pp_kvm_ip_address(uint32_t ip, int ip_valid, uint32_t mask, int mask_valid, uint32_t gw, int gw_valid);

/* tells the kvm lib that the keyboard leds of one of the channels of the kvm switch has changed */
extern void pp_kvm_led_change(u_char channel, u_char scroll_lock, u_char num_lock, u_char caps_lock);

/* Get number of ports currently in kvm switch UNIT.
 *     UNIT must be zero for switches with only one unit. */
EXTERN_C u_short pp_kvm_get_unit_port_count(u_char unit);

/* Tells the lib when kvm switch units are added or removed (Belkin-specific).
 *     UNIT is 0-15, COUNT = number of ports in this unit (0 = removed).  */
EXTERN_C void pp_kvm_set_unit_port_count(u_char unit, u_short count);

/* get number of channels */
EXTERN_C u_char pp_kvm_get_channel_count(void);

/* Returns 1 if the kvm unit with index UNIT is present.  */
EXTERN_C int pp_kvm_is_unit_present(u_char unit);

EXTERN_C int
pp_kvm_get_unit_and_port(pp_kvm_link_client_t client, u_char * unit_p, u_short * port_p);

/* Get current UNIT/PORT providing data_link*/
EXTERN_C int pp_kvm_get_unit_port_for_data_link(u_char data_link, u_char * unit_p, u_short * port_p);

/* Get current UNIT/PORT providing video_link*/
EXTERN_C int pp_kvm_get_unit_port_for_video_link(u_char video_link, u_char * unit_p, u_short * port_p);

EXTERN_C int pp_kvm_get_video_link_for_data_link(u_char data_link, u_char *video_link);
EXTERN_C int pp_kvm_get_video_link(pp_kvm_link_client_t client, u_char *video_link);
EXTERN_C int pp_kvm_get_data_link(pp_kvm_link_client_t client, u_char *data_link);

/**** port switch stuff ****/

EXTERN_C pp_kvm_link_client_t
pp_kvm_new_link_client(eric_session_int_id_t session_id, pp_kvm_session_type_t session_type);

/* switch to a specific port */
EXTERN_C int
pp_kvm_switch_port(pp_kvm_link_client_t client,
	u_char unit, int target_port, u_char* data_link, u_char* video_link);

/* Makes <client> use the given <data_link> and <video_link>.
 *     NB: This is for switches where the links must be chosen explicitly by
 *     the user or where there is only one DL/VL in hardware.  It is _not_ for
 *     switches like KX2, where DL and VL are assigned automatically in the
 *     course of Switch()'ing, and will fail there.
 */
EXTERN_C int
pp_kvm_set_link_client_links(pp_kvm_link_client_t client,
	u_char data_link, u_char video_link);

EXTERN_C int
pp_kvm_release_link_client(pp_kvm_link_client_t client);

/* Has USER the permissions to switch to PORT in UNIT? */
EXTERN_C int pp_kvm_is_port_allowed_for_user(const char * user, u_char unit, u_short port);
//EXTERN_C int pp_kvm_is_port_allowed_for_user(pp_kvm_link_client_t client, u_char unit, u_short port);

/* Has an active host been detected at PORT in UNIT? */
EXTERN_C int pp_kvm_is_host_at_port(u_char unit, u_short port);

/* Is switching to a specific port possible and allowed for this user? */
EXTERN_C int pp_kvm_switch_allowed(const char * user, u_char unit, u_short port);
//EXTERN_C int pp_kvm_switch_allowed(pp_kvm_link_client_t client, u_char unit, u_short port);

/* update the firmware of the MasterConsole IP KVM Switch */
#if defined(PP_FEAT_MASTERCONSOLE_FW_UPDATE)
EXTERN_C int pp_kvm_update_masterconsole_ip_firmware(char * firmware, size_t length);
#endif

/**** default stuff ****/
EXTERN_C int pp_kvm_get_defaultcount(void);
EXTERN_C int pp_kvm_get_defaultduration(int _index);
EXTERN_C const char * pp_kvm_get_defaultname(int _index);
EXTERN_C char ** pp_kvm_get_defaultnames(int _index);
EXTERN_C char ** pp_kvm_get_defaultkeys(int _index);
EXTERN_C int8_t* pp_kvm_get_default_show_in_rc_vals(int _index);


/**** new stuff ****/
EXTERN_C int pp_kvm_get_data_link_id_at_port(int unit, int port, int *data_link_id);
EXTERN_C int pp_kvm_targetstatus_changed(int target_port, int cim_state, int cim_type);
EXTERN_C int pp_kvm_get_client_cnt_on_video_link(int video_link);

#endif /* _PP_KVM_H */
