/*
 * KvmKbdSwitch: Represents devices where key codes trigger port switching.
 *               This class is abstract.
 */

#ifndef _KVM_KBD_SWITCH_H
#define _KVM_KBD_SWITCH_H

#include <pp/vector.h>
#include <pp/kvm.h>

#include "kvm_driver.h"

#define KVM_KEY_RELEASE_ALL	0
#define KVM_KEY_RELEASE_LAST	1

typedef struct {
    vector_t * keys;
    int count;
} kvm_entry_t;

namespace pp
{
class KvmKbdSwitch : public KvmDriver
{
public:
	KvmKbdSwitch();
	virtual ~KvmKbdSwitch();

    int Init();

    /* Sends out the sequence KEY_SEQ of keycodes on CHANNEL.
     * Can be used when keys for port switching are computed ad hoc. */
    int SendKeySeq (u_char channel, char * key_seq);
};

} // namespace

#endif /* _KVM_KBD_SWITCH_H */
