/* global includes */
#include <liberic_config.h>
#include <pp/um.h>

/* local includes */
#include "virt_switch.h"
#include "debug.h"

using namespace pp;

/* Implementation of KvmVirtSwitch.  */


KvmVirtSwitch::KvmVirtSwitch()
{
    DP_VERBOSE("%s called\n", ___F);
}

int
KvmVirtSwitch::Init ()
{
    DP_VERBOSE("%s called\n", ___F);

    return 0;
}

KvmVirtSwitch::~KvmVirtSwitch()
{
    /* destroy non-inherited members */

    /* destroy superclass */
}


int
KvmVirtSwitch::Switch ( LinkClient* client, u_char unit, short unsigned target_port,
				u_char* data_link, u_char* video_link)
{
    pthread_mutex_t * mtx = &_switchPortMtx;
    int	ret = -1;
    char * key_seq = NULL;

// FIXME: just to get it compiling
	//u_char channel = client->GetVideoLinkNumber();
// FIXME: just to get it compiling
    int channel = 0;

    MUTEX_LOCK(mtx);

    /* TODO: currently limited to only one kvm unit */
    if (unit != 0) {
	DP_ERROR("%s: currently no support for multiple units in KvmVirtSwitch\n", ___F);
	goto bail;
    }

    DP_NOTICE("%s: switching channel %hhu to target_port %hu on unit %hhu\n", ___F, channel, target_port, unit);

    /* get the keyseq from config fs */
    if (PP_FAILED(pp_cfg_get_nodflt(&key_seq, "unit[%u].target_port[%u].hotkey.code", unit, target_port))) {
	goto bail;
    }

    /* send the keys out */
    if (SendKeySeq ( channel, key_seq) != 0) {
	goto bail;
    }

    /* Note: switch gives no feedback -> manually notify of target_port change */
    PortChanged( channel, unit, target_port);

    ret = 0;

bail:
    MUTEX_UNLOCK(mtx);
    free(key_seq);
    return ret;
}

u_short
KvmVirtSwitch::GetUnitPortCount(u_char unit)
{
    u_short nr_ports = 0; /* FIXME: ok? or is 1 better? */

    if (unit == 0) {
	/* cannot get info from switch, so use user-configured number of ports */
	pp_cfg_get_ushort_nodflt(&nr_ports, "unit[%u].port._s_", unit);
        /* we need at least one port for unit 0! */
        assert(nr_ports);
    }

    DP_VERBOSE("%s(): unit %hhu has %u ports\n", ___F, unit, nr_ports);
    return nr_ports;
}
