/* xx01IP: a 1601IP or 0801IP switch. */

#ifndef KVM_XX01IP_H
#define KVM_XX01IP_H

#include "kbd_switch.h"

namespace pp
{
class KvmXx01ip : public KvmKbdSwitch
{
private:
    /* TODO: rename members to m_ */

    /* volatile + mutex needed for safe read/write between threads */
    volatile unsigned char _portChangeState;
    pthread_cond_t _portChangeCond;
    pthread_mutex_t _portChangeMtx;

    volatile int _readerSleeping;
    pthread_mutex_t _readerSleepingMtx;
    pthread_cond_t _readerSleepingCond;
    volatile int _FwUpdateInProgress;

    volatile unsigned char _readerThreadRun;
    pthread_t _readerThread;
    int _readerFd;
public:
    KvmXx01ip();
    virtual ~KvmXx01ip();

    int InitReader ();
    void DestroyReader ();
    static void * ReaderThreadFunc (void *arg);
    int Switch ( LinkClient* client, u_char unit, u_short target_port,
				u_char* data_link, u_char* video_link);
    void WaitForPortchange();
    void PortChanged (int channel, int newunit, int newport);

#if defined(PP_FEAT_MASTERCONSOLE_FW_UPDATE)
    int UpdateMasterConsoleFirmware( char* firmware, size_t length);
#endif
    int IsPortAllowedForUser ( const char* user, int unit, int kvm_port);
};

} // namespace

#endif


