#ifndef _PP_POWER_SWITCH_H
#define _PP_POWER_SWITCH_H

#include <pp_kernel_common.h>

#include "power_switch_common.h"

/* forward declaration - must be before power_switch_*.includes */
typedef struct power_switch_s power_switch_t;

#include "power_switch_btec.h"
#include "power_switch_fjsms.h"
#include "power_switch_psu_adapt.h"
#include "power_switch_intern.h"
#include "power_switch_ipm_gpio.h"
#include "power_switch_ipm_tty.h"
#include "power_switch_les.h"
#include "power_switch_lesms.h"
#include "power_switch_sentry.h"
#include "power_switch_smart.h"
#include "power_switch_spc.h"
#include "power_switch_ipwr.h"

#define noPOWER_DEBUG	                1
#define MAX_POWER_SWITCH_NAME_LEN	16
#define MAX_PORT_CONTEXTS               32

typedef union {
    u_int port_id;
    ps_btec_t btec;
    ps_fjsms_t fjsms;
    ps_intern_t intern;
    ps_psu_adapt_t psu_adapt;
    ps_ipmgpio_t ipmgpio;
    ps_ipmtty_t ipmtty;
    ps_les_t les;
    ps_lesms_t lesms;
    ps_sentry_t sentry;
    ps_smart_t smart;
    ps_spc_t spc;
    ps_ipwr_t ipwr;
} ps_data_t;

typedef struct {
    pthread_mutex_t lock;
    power_switch_t * ps;
    int logged_in;
    ps_data_t ps_data;
} port_ctx_t;

struct power_switch_s {
    int (*init)(power_switch_t * this, ps_data_t * ps_data);

    void (*uninit)(power_switch_t * this, ps_data_t * ps_data);

    int (*login)(power_switch_t * this, ps_data_t * ps_data);

    int (*logout) (power_switch_t * this, ps_data_t * ps_data);

    int (*lookup_devices) (power_switch_t * this, ps_data_t * ps_data);

    int	(*power_switch)(power_switch_t * this, ps_data_t * ps_data,
			int port, int device, u_char on, int seq);

    int	(*power_switch_all)(power_switch_t * this, ps_data_t * ps_data,
			int device, unsigned char on);

    int	(*power_switch_simultan)(power_switch_t * this, ps_data_t * ps_data,
			int device, unsigned short port_values);

    int	(*power_button)(power_switch_t * this, ps_data_t * ps_data,
			int port, int device, u_char pb_enabled, int seq);
    
    int	(*stdby_switch)(power_switch_t * this, ps_data_t * ps_data,
			int port, int device, u_char on, int seq);
    
    int	(*do_reset)(power_switch_t * this, ps_data_t * ps_data,
		    int port, int device);

    int	(*get_state)(power_switch_t * this, ps_data_t * ps_data,
		     int port, int device);

    int (*get_count)(power_switch_t * this, ps_data_t * ps_data,
		     int device, int object);

    char* (*get_name)(power_switch_t * this, ps_data_t * ps_data,
		      int idx, int device, int object);

    int (*set_name)(power_switch_t * this, ps_data_t * ps_data,
		    int idx, int device, int object, const char * name);

    unsigned short* (*get_port_delays)(power_switch_t * this, ps_data_t * ps_data,
		      int idx, int device);

    int   (*set_port_delays)(power_switch_t * this, ps_data_t * ps_data,
		      int idx, int device, unsigned short* delay);    

    char* (*get_temp)(power_switch_t * this, ps_data_t * ps_data,
		      int device);

    char* (*get_data)(power_switch_t * this, ps_data_t * ps_data,
		      int device, int channel, int type);

    char* (*get_temperature)(power_switch_t * this, ps_data_t * ps_data,
			     int device);

    int (*ext_switch)(power_switch_t * this, ps_data_t * ps_data,
		      int port, int device, u_char on);

    int (*get_ext_state)(power_switch_t * this, ps_data_t * ps_data,
			 int port, int device);

    int (*get_sw_version)(power_switch_t * this, ps_data_t * ps_data,
		      int device);

    char* (*get_current)(power_switch_t * this, ps_data_t * ps_data,
		      int device);

    int (*get_delay_enable)(power_switch_t * this, ps_data_t * ps_data,
		      int device);

    int (*set_delay_enable)(power_switch_t * this, ps_data_t * ps_data,
			    int device, u_char enable);
    

    unsigned int caps;
    unsigned int allowed_port_ids;
};

typedef struct {
    char name[MAX_POWER_SWITCH_NAME_LEN];
    int (*init)(power_switch_t *this);
    void (*cleanup)(void* this);
    u_int allowed_port_ids;
} power_switch_entry_t;

#endif /* _PP_POWER_SWITCH_H */
