#ifndef _PP_POWER_SWITCH_COMMON_H
#define _PP_POWER_SWITCH_COMMON_H

/*********************************************************************
 *
 * Common functions for power switch handling
 *
 *********************************************************************/

typedef enum {
    TTY_READ_STRING,    /* read until @text is seen */
    TTY_READ_STOP_CHR,  /* read until @chr (stop char) is seen */
    TTY_READ_MAX_CHR,   /* read until timeout due to inactivity */
    TTY_READ_IPWR_MSG,  /* IP-Power specific */
} read_response_mode_t;

int ps_get_fd_by_port_id(u_int port_id);

/**
 * Reads data from @fd and returns it in @buf (max @buf_size bytes).
 *     - timeout can be specified by @sec (secs) and @usec (microsecs)
 *     - @mode specifies the mode of operation:
 *         - search for @text
 *         - search for @char
 *         - read until timeout
 *	   - @buf_size is the size of the whole buffer
 *	   - @buf_len_p will be filled with the byte count actually used
 *         - ...
 *     - return value is PP_SUC on success, else PP_ERR
 */
int ps_read_response(int fd, char chr, const char* text, u_long sec,
		     u_long usec, char * buf, size_t buf_size,
		     size_t * buf_len_p, read_response_mode_t mode);

/**
 * get a possible custom name for the power switch from config fs,
 * otherwise return a copy of the given default string
 *
 * caller needs to free the result
 */
char* ps_get_pswitch_name(const char* ps, int obj);

#endif /* _PP_POWER_SWITCH_COMMON_H */
