/**
 * pp_RDM_Power.h
 * 
 * Implements the RDM power services. Derives CRDM_Power and
 * fills all the empty function calls.
 *
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __PP_RDM_POWER_H__
#define __PP_RDM_POWER_H__

 
#include "pp/RDM_Power.h"


class PP_RDM_Power : public CRDM_Power
{
public:

    /**
     *
     */
    PP_RDM_Power(CRDM* rdm);

    /**
     *
     */
    virtual ~PP_RDM_Power();



protected:
    /**
     * 
     */
    virtual
    int                             // I/O error on output
    DEP_SetPowerStateOfOutlet (char* pID, int state);

    /**
     * Return the result for Power Strip Status command.
     * Returns NULL as Peppercon does not have 'intelligent' Powerstrips (yet).
     */
    virtual
    char *                                  // NULL on error
    DEP_GetPowerStripStatus (char* pID);
    
};

#endif // __PP_RDM_POWER_H__

