/**
 * pp_RDM_System.h
 * 
 * Implements the RDM system services. Derives CRDM_System and
 * fills all the empty function calls.
 *
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __PP_RDM_SYSTEM_H__
#define __PP_RDM_SYSTEM_H__

 
#include "pp/RDM_System.h"
#include "pp/CC.h"
extern "C" {
#include "pp/cfg.h"
}


class PP_RDM_System : public CRDM_System
{
public:

    PP_RDM_System(CRDM* pRDM, CCommandCenter* cc);

    ~PP_RDM_System();


    /*
     * Not implemented here:
     * DEP_Shutdown
     * DEP_Restart()
     * DEP_GetCCDeviceSettings()
     * DEP_CommitCCDeviceSettings()
     * DEP_CloseAllVideoStreams()
     * 
     * CRDM_System by default calls the corresponding functions from RDM_OS_Dependent.h
     */

    /**
     * Initialize the management mode, called after all CC device settings have been written.
     * May return false if the device is in use.
     */
    virtual
    BOOL
    DEP_InitializeManagement();

    /**
     * Called to save the CC Settings
     */
	void
	PP_RDM_System::DEP_CommitCCDeviceSettings();

    /**
     * Returns whether the device is currently managed or not
     */
    virtual
    BOOL
    DEP_AreWeManaged();

    /**
     * Called to stop management mode, called after the cc device settings have been written.
     */
    virtual
    void
    DEP_StopManagement();

    /**
     * set this->version ?
     */
    virtual
    void    
    DEP_SetVersion(int version);
    
private:
    /* commandcenter object that handles the CC managed mode */
    CCommandCenter* commandCenter;

};

#endif


