/**
 * powerport_lipp_powerswitch.cpp
 * 
 * A port object for power ports. Represents a <port> entry in the RDM database.
 * The pp_RDM_Power service forwards power control requests to this object.
 * Implements a powerport that can be controlled with libpp_powerswitch.
 * 
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#include "powerport_libpp_powerswitch.h"
#include <stdio.h>

extern "C" {
#include "pp/powerswitch.h"
}

static const char* port_id_names[] = {"intern", "ttyS0", "ttyS1"};


PP_RDM_PowerPort_libpp_powerswitch::PP_RDM_PowerPort_libpp_powerswitch
                                      (CRDM* rdm, PP_DDA_Device* rdm_device,
                                       unsigned int new_port_id, int new_device, int new_port)
                                  : PP_DDA_PowerPort(rdm)
{
    char _id[RDM_MAX_ID];
    port_id = new_port_id;
    device = new_device;
    port = new_port;
    //const char *_pName = port_id_names[ffs(port_id)-1];

    
    // create a unique id
    snprintf(_id, sizeof(_id), "%s_%02x_%02x", port_id_names[ffs(port_id)-1], device, port);
//    snprintf(id, RDM_MAX_ID, "%s_%02x_%02x", /*port_id_names[ffs(port_id)-1]*/ _pName, device, port);
    
    PP_DDA_PowerPort::initialize(rdm, rdm_device, _id, "Outlet", 0);
}

PP_RDM_PowerPort_libpp_powerswitch::~PP_RDM_PowerPort_libpp_powerswitch() {
    // remove from rdm database somehow, use super() to do that
}

int
PP_RDM_PowerPort_libpp_powerswitch::setPowerStateOfOutlet(int state) {
    int ret = 0;
    printf("powerport_libpp_powerswitch: SetPowerStateOfOutlet %d, %d, %d = %d\n", port, device, port_id, state);
    // switch the power
    
    if (pp_power_login(port_id) != PP_SUC) {
        printf("powerport_libpp_powerswitch: login failed\n");
        return PP_ERR;
    }
    // FIXME: state parameter here is something different (long press/short press ?)
    ret =  pp_power_switch(port, device, (unsigned char)state, 0, port_id);
    
    pp_power_logout(port_id);
    
    return ret;
}

char*
PP_RDM_PowerPort_libpp_powerswitch::getPowerStripStatus() {
    // not implemented (yet ?)
    printf("powerport_libpp_powerswitch: GetPowerStripStatus()\n");
    return NULL;
}


