/**
 * powerport_lipp_powerswitch.h
 * 
 * A port object for power ports. Represents a <port> entry in the RDM database.
 * The pp_RDM_Power service forwards power control requests to this object.
 * Implements a powerport that can be controlled with libpp_powerswitch.
 * 
 * (c) 2006 Peppercon AG, Georg Hoesch <geo@peppercon.de>
 */

#ifndef __PP_POWERPORT_LIBPP_POWERSWITCH_H__
#define __PP_POWERPORT_LIBPP_POWERSWITCH_H__

#include "PP_DDA_objects.h"

extern "C" {
#include "pp/powerswitch.h"
}

class PP_RDM_PowerPort_libpp_powerswitch: public PP_DDA_PowerPort {
public:
    /**
     * Create a powerport in the RDM database that corresponds that can be controlled
     * with the specified parameters of libpp_powerswitch.
     */
    PP_RDM_PowerPort_libpp_powerswitch(CRDM* rdm, PP_DDA_Device* rdm_device,
                                       unsigned int port_id, int device, int port);

    /**
     * Remove the corresponding powerport from the RDM database.
     */
    virtual
    ~PP_RDM_PowerPort_libpp_powerswitch();
    
    /**
     * Set the state of this outlet, use DEFINES from RDM_Power.h
     * Override in derived object.
     */
    virtual
    int setPowerStateOfOutlet(int state);
    
    /**
     * Set the state of the power strip, return NULL if not applicable.
     * Override in derived object.
     */
    virtual
    char* getPowerStripStatus ();

private:
    unsigned int port_id;   // port type (intern, serial1, serial2)
    int device;             // device number of chained devices connected to port_id
    int port;               // port within selected device.
};

#endif

