#ifndef _PP_SERIAL_H
#define _PP_SERIAL_H

#include <sys/types.h>

typedef int (*pp_serial_init_func_t)(const char *, u_int id, u_int fd, char **);
typedef int (*pp_serial_uninit_func_t)(const char *, u_int id, u_int fd, char **);

typedef enum {
    PP_SERIAL_USAGE_DISABLED,
    PP_SERIAL_USAGE_MODEM,
    PP_SERIAL_USAGE_CONFIGLOGIN,
    PP_SERIAL_USAGE_IPMI,
    PP_SERIAL_USAGE_PASSTHROUGH,
    PP_SERIAL_USAGE_EXTERNALPOWER,

    /* must be the last! */
    PP_SERIAL_USAGE_COUNT
} pp_serial_usage_t;

int pp_serial_init(void);
void pp_serial_cleanup(void);
int pp_serial_register_port(const char * device_path, int has_hw_flowctrl, u_int id);
void pp_serial_unregister_port(u_int id);
void pp_serial_register_port_callbacks(pp_serial_usage_t usage, pp_serial_init_func_t init, pp_serial_uninit_func_t uninit);
void pp_serial_unregister_port_callbacks(pp_serial_usage_t usage);
int pp_serial_port_get(u_int id);
int pp_serial_reconfigure(char ** errstr_p);

#endif /* _PP_SERIAL_H */
