#ifndef _PP_SETUP_PROTO_H
#define _PP_SETUP_PROTO_H

#if !defined(PP_CYGWIN)
#include <netinet/if_ether.h>
#endif
#include <netinet/in.h>
#include <sys/types.h>
#include <pp/base.h>

#if defined(PP_CYGWIN)
#define ETH_ALEN        6               /* Octets in one ethernet addr   */
#define ETH_HLEN        14              /* Total octets in header.       */
#define ETH_ZLEN        60              /* Min. octets in frame sans FCS */
#define ETH_DATA_LEN    1500            /* Max. octets in payload        */
#define ETH_FRAME_LEN   1514            /* Max. octets in frame sans FCS */
#endif

#define PP_SP_REQ_MTU	(ETH_DATA_LEN - 60 /* ip */- 8 /* udp */)
#define PP_SP_RSP_MTU	(ETH_DATA_LEN - 60 /* ip */- 8 /* udp */)

/* Do not change the DEVICE_ID_LEN! It may break alignment in some structures */
#define DEVICE_ID_LEN 6

#define PP_SP_PROP_SUPER_USER_NAME		"su"
#define PP_SP_PROP_SUPER_USER_PASSWORD		"supw"
#define PP_SP_PROP_SUPER_USER_PASSWORD_NEW	"supwnew"
#define PP_SP_PROP_IP_AUTO_CONFIG_PROTO		"ipacp"
#define PP_SP_PROP_IP_ADDRESS			"ip"
#define PP_SP_PROP_NETMASK			"nm"
#define PP_SP_PROP_GATEWAY			"gw"
#define PP_SP_PROP_BOARD_NAME			"bn"
#define PP_SP_PROP_FW_VERSION			"fwv"
#define PP_SP_PROP_INTERFACE                    "eth"
#define PP_SP_PROP_SERIAL			"serial"
#define PP_SP_PROP_CLUSTER_SUPPORTED		"cl"
#define PP_SP_PROP_CLUSTER_MTIME		"clmtime"
#define PP_SP_PROP_CLUSTER_IP			"clip"
#define PP_SP_PROP_CLUSTER_NETMASK		"clnm"
#define PP_SP_PROP_CLUSTER_GATEWAY		"clgw"
#define PP_SP_PROP_CLUSTER_NODE_CNT		"clcnt"
#define PP_SP_PROP_CLUSTER_NODE_MAP_PATTERN	"clmap%u"
#define PP_SP_PROP_CLUSTER_NODE_ID		"clnid"
#define PP_SP_PROP_WLAN_ESSID                   "essid"
#define PP_SP_PROP_WLAN_WEP_ENABLED             "wep"
#define PP_SP_PROP_WLAN_WEP_KEY                 "key"
#define PP_SP_PROP_WLAN_MODE                    "wmode"

#define PP_SP_CMD_QUERY			0
#define PP_SP_CMD_SETUP			1
#define PP_SP_CMD_PING			2
#define PP_SP_CMD_CLUSTER_CONFIGURE	3

#define PP_SP_RSP_SUCCESS		0
#define PP_SP_RSP_UNSPEC_ERR		1
#define PP_SP_RSP_PERM_DENIED		2
#define PP_SP_RSP_AUTH_FAILED		3
#define PP_SP_RSP_PARAM_ERR		4

typedef struct {
    in_addr_t  src_in_addr;
    u_int8_t  src_hw_addr[ETH_ALEN];
    u_int8_t  dev_id[DEVICE_ID_LEN];
    u_int8_t  command;
    pp_prop_t props;
    u_int32_t id;
} pp_setup_req_t;

typedef struct {
    in_addr_t  dst_in_addr;
    u_int8_t  dst_hw_addr[ETH_ALEN];
    u_int8_t  dev_id[DEVICE_ID_LEN];
    u_int8_t  response_code;
    pp_prop_t props;
    u_int32_t id;
} pp_setup_rsp_t;

typedef enum {
    PP_SETUP_PROTO_USB,
    PP_SETUP_PROTO_NETLINK
} pp_setup_proto_comm_type_t;

#ifdef __cplusplus
extern "C" {
#endif

extern int pp_setup_proto_errno_base;

int pp_setup_proto_init(void);
void pp_setup_proto_cleanup(void);

pp_setup_req_t * pp_setup_proto_req_create(const char * if_name, void * data, size_t len, u_int8_t * src_hw_addr, in_addr_t src_in_addr);
void pp_setup_proto_req_free(pp_setup_req_t * req);
int pp_setup_proto_req_set_property(pp_setup_req_t * req, const char * key, const char * val);
const char * pp_setup_proto_req_get_property(pp_setup_req_t * req, const char * key);
int pp_setup_proto_req_send(pp_setup_req_t * req);
pp_setup_req_t * pp_setup_proto_req_recv(int timeout, int * timedout);
void pp_setup_proto_answer_request(int ms_index, pp_setup_req_t * req, pp_setup_proto_comm_type_t comm_type);
void pp_setup_proto_req_handle_usb(int ms_index, char* sp_pdu, ssize_t sp_pdu_len);
pp_setup_rsp_t * pp_setup_proto_scsi_request_response(int fd, pp_setup_req_t * req, int retries);

static inline void
pp_setup_proto_req_set_device_id(pp_setup_req_t * req, const u_int8_t * dev_id)
{
    memcpy(req->dev_id, dev_id, sizeof(req->dev_id));
}

static inline const u_int8_t *
pp_setup_proto_req_get_device_id(pp_setup_req_t * req)
{
    return req->dev_id;
}

static inline in_addr_t
pp_setup_proto_req_get_src_in_addr(pp_setup_req_t * req)
{
    return req->src_in_addr;
}

static inline const u_int8_t *
pp_setup_proto_req_get_src_hw_addr(pp_setup_req_t * req)
{
    return req->src_hw_addr;
}

static inline void
pp_setup_proto_req_set_cmd(pp_setup_req_t * req, u_int8_t command)
{
    req->command = command;
}

static inline u_int8_t
pp_setup_proto_req_get_cmd(pp_setup_req_t * req)
{
    return req->command;
}

static inline void
pp_setup_proto_req_set_id(pp_setup_req_t * req, u_int32_t id)
{
    req->id = id;
}

static inline u_int32_t
pp_setup_proto_req_get_id(pp_setup_req_t * req)
{
    return req->id;
}

pp_setup_rsp_t * pp_setup_proto_rsp_create(void * data, size_t len);
void pp_setup_proto_rsp_free(pp_setup_rsp_t * rsp);
int pp_setup_proto_rsp_set_property(pp_setup_rsp_t * rsp, const char * key, const char * val);
const char * pp_setup_proto_rsp_get_property(pp_setup_rsp_t * rsp, const char * key);
int pp_setup_proto_rsp_send(int ms_index, pp_setup_rsp_t * rsp, pp_setup_proto_comm_type_t comm_type);
pp_setup_rsp_t * pp_setup_proto_rsp_recv(int timeout, int * timedout);

static inline void
pp_setup_proto_rsp_set_device_id(pp_setup_rsp_t * rsp, const u_int8_t * dev_id)
{
    memcpy(rsp->dev_id, dev_id, sizeof(rsp->dev_id));
}

static inline const u_int8_t *
pp_setup_proto_rsp_get_device_id(pp_setup_rsp_t * rsp)
{
    return rsp->dev_id;
}

static inline void
pp_setup_proto_rsp_set_dst_in_addr(pp_setup_rsp_t * rsp, in_addr_t dst_in_addr)
{
    rsp->dst_in_addr = dst_in_addr;
}

static inline void
pp_setup_proto_rsp_set_dst_hw_addr(pp_setup_rsp_t * rsp, const u_int8_t * dst_hw_addr)
{
    memcpy(rsp->dst_hw_addr, dst_hw_addr, sizeof(rsp->dst_hw_addr));
}

static inline void
pp_setup_proto_rsp_set_id(pp_setup_rsp_t * rsp, u_int32_t id)
{
    rsp->id = id;
}

static inline u_int32_t
pp_setup_proto_rsp_get_id(pp_setup_rsp_t * rsp)
{
    return rsp->id;
}

static inline void
pp_setup_proto_rsp_set_code(pp_setup_rsp_t * rsp, u_int8_t code)
{
    rsp->response_code = code;
}

static inline u_int8_t
pp_setup_proto_rsp_get_code(pp_setup_rsp_t * rsp)
{
    return rsp->response_code;
}

#ifdef __cplusplus
}
#endif

#endif /* _PP_SETUP_PROTO_H */
