/**
 * main.c
 *
 * Standalone encrypter for user passwords.
 * Calculates a pw_hash and pw_encr values for config system.
 *
 * (c) 2006 Raritan, ralf.guenther@raritan.com
 */

#include <stdio.h>
#include <string.h>
#include <openssl/md5.h>
#include <openssl/evp.h>

/*
 * md5_hash_to_str()
 *
 * This routine converts a MD5 hash into its string representation.
 * (taken from libpp_base/src/misc.c)
 */
void
pp_md5_hash_to_str(const char * hash, char * hash_str)
{
    char * hs = hash_str;
    int i;

    for (i = 0; i < MD5_DIGEST_LENGTH; i++, hs += 2) {
	sprintf(hs, "%02x", (unsigned char)hash[i]);
    }
}

/*
 * (taken from libpp_um/src/um.c)
 */
#define cons_encrypt(dest, src, len) cons_crypt(dest, src, len, 1)
#define cons_decrypt(dest, src, len) cons_crypt(dest, src, len, 0)

static const u_char * key_buf =
    "\x90\x2b\xbc\x95\x3d\xbc\x44\x79\xbb\x88\x92\x52\x58\xed\x16\xf5"
    "\x6b\xdf\x1b\x65\x59\x40\x1b\xb9\x86\xc6\x7a\x64\x88\xd6\xb0\x94"
    "\x37\x6f\xb1\x22\x37\x07\xce\xf3\x35\x3b\xab\x0c\x7f\x39\xbf\x4f"
    "\x66\x40\x66\x92\x6e\x0e\x0a\xcf\x14\x23\x48\xfb\xb2\x88\x1d\xbe"
    "\x36\xe8\x43\x69\x49\xe3\x1d\xca\xe1\x83\x63\x35\xd4\x82\xfe\x8c"
    "\xf4\xe0\x65\x8f\xaa\x2e\x81\x6a\xb9\x4d\x43\xa1\x39\x00\x2a\xe2"
    "\x26\x7e\x66\x7c\xc2\xf4\xe1\xe6\x78\xda\xb7\xe9\x22\x29\x4b\x49"
    "\xf2\xd9\xc3\xd8\x20\x58\x68\x7a\xe3\x3f\x44\xb5\x93\xe4\x3a\x14";

static int
cons_crypt(char * dest, const char * src, size_t len, int do_encrypt)
{
    static EVP_CIPHER_CTX ctx;
    static const EVP_CIPHER *cipher;
    static u_char key[EVP_MAX_KEY_LENGTH], iv[EVP_MAX_IV_LENGTH];
    static int init = 0;
    int update_len, final_len;

    if (!init) {
        cipher = EVP_aes_128_cfb();
        EVP_BytesToKey(cipher, EVP_md5(), NULL, key_buf, strlen(key_buf), 1, key, iv);
        EVP_CIPHER_CTX_init(&ctx);
        init = 1;
    }

    EVP_CipherInit_ex(&ctx, cipher, NULL, key, iv, do_encrypt);

    if (!EVP_CipherUpdate(&ctx, dest, &update_len, src, len)) {
        printf("EVP_CipherUpdate() failed\n");
        return -1;
    }

    if (!EVP_CipherFinal_ex(&ctx, &dest[update_len], &final_len)) {
        printf("EVP_CipherFinal() failed\n");
        return -1;
    }

    return 0;
}

char* pp_um_passwd_encrypt(const char* passwd)
{
    char plain[1 + 64]; // salt + passwd
    char encr[1 + 64]; // encr code (same size)
    char *mem, *code;
    BIO *bio;
    int sz = (sizeof(encr) + 2) / 3 * 4; // base64 enc size

    if (strlen(passwd) > 64) return NULL; // passwd too long

    // encrypting
    srand(time(NULL));
    plain[0] = rand() & 0xff; // set salt value
    strncpy(plain + 1, passwd, sizeof(plain) - 1); // add passwd padded with 0s
    if (cons_encrypt(encr, plain, sizeof(plain)) < 0) return NULL;

    // base64-encoding
    bio = BIO_new(BIO_f_base64());
    BIO_set_flags(bio, BIO_FLAGS_BASE64_NO_NL);
    bio = BIO_push(bio, BIO_new(BIO_s_mem()));
    BIO_write(bio, encr, sizeof(encr));
    BIO_flush(bio);
    sz = BIO_get_mem_data(bio, &mem);
    code = malloc(sz + 1);
    memcpy(code, mem, sz);
    code[sz] = '\0';
    BIO_free_all(bio);

    return code;
}

int main (int argc, char** argv)
{
    char md5_hash[MD5_DIGEST_LENGTH];
    char md5_hash_str[MD5_DIGEST_LENGTH * 2 + 1];
    char *pw_encr;

    if (argc != 2) {
       printf("Usage: %s <password>\n", argv[0]);
       printf("Calculates a pw_hash and pw_encr values.\n");
       return 0;
    }

    MD5(argv[1], strlen(argv[1]), md5_hash);
    pp_md5_hash_to_str(md5_hash, md5_hash_str);

    printf("pw_hash = \"%s\"\n", md5_hash_str);

    pw_encr = pp_um_passwd_encrypt(argv[1]);
    if (!pw_encr) {
        printf("Error while calculating pw_encr\n");
    } else {
        printf("pw_encr = \"%s\"\n", pw_encr);
        free(pw_encr);
    }

    return 0;
}
