/*
 *  linux/arch/armnommu/mach-faraday/platform-a320/pci_intc.c
 *
 *  Faraday PCI Bridge Interrupt Process Driver Implementation
 *
 *  Copyright (C) 2005 Faraday Corp. (http://www.faraday-tech.com)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  
 * ChangeLog
 * 
 *  Luke Lee  09/15/2005  Created.
 *  Luke Lee  09/27/2005  Fixed for parent chip registration and notification.
 *  Peter Liao 09/28/2005 Port for PCI IP
 */

#include <linux/interrupt.h>
#include <linux/ioport.h>
#include <asm/io.h>

#include <asm/mach/irq.h>
#include <asm/arch/intc.h>
#include <asm/arch/spec.h>
#include <asm/arch/ftpci.h>

#define IPMODULE PCIC
#define IPNAME   FPCI010

/*
 * Level trigger IRQ chip methods
 */
static void fia321_intc_ftpci100_level_ack_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        if(!ftpci_probed)
        	return;
        ftpci_clear_irq(irq-PLATFORM_FIA321_PCI_IRQ_BASE);
        // Ack parent chip (recursively)
	irq_desc[parent_chip_irq].chip->ack(parent_chip_irq);
}

static void fia321_intc_ftpci100_level_mask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        if(!ftpci_probed)
        	return;
        // Mask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->mask(parent_chip_irq);
	ftpci_clear_irq(irq-PLATFORM_FIA321_PCI_IRQ_BASE);
}

static void fia321_intc_ftpci100_level_unmask_irq(unsigned int irq)
{
        unsigned parent_chip_irq = (unsigned)get_irq_chipdata(irq);
        if(!ftpci_probed)
        	return;
        ftpci_clear_irq(irq-PLATFORM_FIA321_PCI_IRQ_BASE);
        // Unmask parent chip (recursively)
	irq_desc[parent_chip_irq].chip->unmask(parent_chip_irq);
}

static struct irqchip fia321_intc_ftpci100_level_chip = {
	.ack	= fia321_intc_ftpci100_level_ack_mask_irq,
	.mask	= fia321_intc_ftpci100_level_mask_irq,
	.unmask = fia321_intc_ftpci100_level_unmask_irq
};

int __init fia321_intc_ftpci100_init_irq(void)
{
        int i;
    
        /* Register all IRQ */
        for (i = PCIC_FTPCI100_IRQ0 ;
             i < PCIC_FTPCI100_IRQ0 + PCIC_FTPCI100_IRQ_COUNT;
             i++ )
        {
                // level trigger
                set_irq_chip(i, &fia321_intc_ftpci100_level_chip);
                set_irq_handler(i, do_level_IRQ);
                set_irq_flags(i, IRQF_VALID | IRQF_PROBE);
                set_irq_chipdata( i, (void*) PLATFORM_FIA321_IRQ_BASE+PLATFORM_FIA321_PCI_IRQ );
        }

        return 0;
}

arch_initcall( fia321_intc_ftpci100_init_irq );
