/*
 *
 *    Copyright (c) 2003-2005 Peppercon AG
 *
 *    Module name: peppercon.h
 *
 *    Description:
 *      Macros, definitions, and data structures specific to Peppercon's
 *      remote management boards.
 *
 * Please read the COPYING file for all license details.
 */

#ifdef __KERNEL__
#ifndef __ASM_PEPPERCON_H__
#define __ASM_PEPPERCON_H__

/* We have a 405EP core */
#ifdef LARA_KACY
#include <platforms/4xx/ibm405gpr.h>
#else
#include <platforms/4xx/ibm405ep.h>
#endif
#ifndef __ASSEMBLY__
/*
 * Data structure defining board information maintained by the boot
 * ROM on IBM's "Walnut" evaluation board. An effort has been made to
 * keep the field names consistent with the 8xx 'bd_t' board info
 * structures.
 */

typedef struct board_info {
    unsigned long   bi_memstart;	/* start of  DRAM memory              */
    unsigned long   bi_memsize;		/* size  of  DRAM memory in bytes     */
    unsigned long   bi_flashstart;	/* start of FLASH memory              */
    unsigned long   bi_flashsize;	/* size  of FLASH memory              */
    unsigned long   bi_flashoffset;	/* reserved area for startup monitor  */
    unsigned long   bi_sramstart;	/* start of  SRAM memory              */
    unsigned long   bi_sramsize;	/* size  of  SRAM memory              */
    unsigned long   bi_bootflags;	/* boot / reboot flag (for LynxOS)    */
    unsigned long   bi_ip_addr;		/* IP Address                         */
    unsigned char   bi_enetaddr[2][6];	/* Ethernet adress                    */
    unsigned short  bi_ethspeed;	/* Ethernet speed in Mbps             */
    unsigned long   bi_intfreq;		/* Internal Freq, in MHz              */
    unsigned long   bi_busfreq;		/* Bus Freq, in MHz                   */
    unsigned long   bi_baudrate;	/* Console Baudrate                   */
    unsigned char   bi_s_version[4];	/* Version of this structure          */
    unsigned char   bi_r_version[32];	/* Version of the ROM (IBM)           */
    unsigned int    bi_procfreq;	/* CPU (Internal) Freq, in Hz         */
    unsigned int    bi_plb_busfreq;	/* PLB Bus speed, in Hz               */
    unsigned int    bi_pci_busfreq;	/* PCI Bus speed, in Hz               */
    unsigned char   bi_pci_enetaddr[6];	/* PCI Ethernet MAC address           */
    unsigned int    bi_debug_mode;	/* 1 if debug cable detected          */
    unsigned int    bi_def_jumper_set;	/* defaults jumper state              */
    unsigned int    bi_not_used;	/* not used                           */
    unsigned int    bi_config_mode;	/* 1 if config command used for boot  */
    unsigned int    bi_opb_busfreq;	/* OPB Bus speed, in Hz               */
    int             bi_iic_fast[1];	/* Use fast i2c mode                  */
    unsigned char   bi_hwid;		/* hardware id of the board           */
    unsigned int    bi_epb_busfreq;	/* EPB Bus speed, in Hz               */
} bd_t;

/* Some 4xx parts use a different timebase frequency from the internal clock.
*/
#define bi_tbfreq bi_intfreq

/* Memory map for the Peppercon boards.  */

#ifdef CONFIG_PPC405GP_INTERNAL_CLOCK
# define BASE_BAUD              201600
#else
# ifdef LARA_KACY
/* how to calculate: CPU clock / ( 16 * UART clock divider in CPC0_CRO )
 *		      = 400Mhz / ( 16 * 30 ) = 833333
 * must be adjusted if different CPU clock is used
 * we should try to calculate this with the information from u-boot bd_t 
 */
#  define BASE_BAUD              833333
# else
#  define BASE_BAUD              691200
# endif
#endif

#define PPC4xx_MACHINE_NAME    "Peppercon KIM"

#define RTC_ALWAYS_BCD  1

#ifdef PP_FEAT_SYSOK_BLINKING
extern void pp_status_led_blinking(unsigned char blinking);
#endif

#endif /* !__ASSEMBLY__ */
#endif /* __ASM_PEPPERCON_H__ */
#endif /* __KERNEL__ */
