/* ahb_dma.h */
#ifndef _APB_DMA_H_
#define _APB_DMA_H_

/* register definition */
#define APBDMA_CHANNEL_BASE 0x20

#define APBDMA_CHANNEL_SRC  0x0
#define APBDMA_CHANNEL_DEST 0x1
#define APBDMA_CHANNEL_CYC  0x2
#define APBDMA_CHANNEL_CMD  0x3

#define APBDMA_WIDTH_8BIT   0x2
#define APBDMA_WIDTH_16BIT  0x1
#define APBDMA_WIDTH_32BIT  0x0

#define APBDMA_TYPE_APB     0
#define APBDMA_TYPE_AHB     1

#define APBDMA_NO_TRIGGER_IRQ   0x0
#define APBDMA_TRIGGER_IRQ      0x1

#define APBDMA_CTL_FIX      0
#define APBDMA_CTL_INC1     1
#define APBDMA_CTL_INC2     2
#define APBDMA_CTL_INC4     4
#define APBDMA_CTL_INC8     8
#define APBDMA_CTL_INC16    16
#define APBDMA_CTL_DEC1     (-1)
#define APBDMA_CTL_DEC2     (-2)
#define APBDMA_CTL_DEC4     (-4)

#define INT_TRIGGER 0x01
#define INT_ERROR   0x02

#define APB_DMA_MAX_CHANNELS	4

typedef void (*apb_dma_irq_handler_t) (void *isr_data);

typedef struct
{
    /* add dma parameter */
    unsigned int    src;        // source address for dma
    unsigned int    dest;       // dest address for dma
    unsigned int    width;      // data width (0/1/2=>8/16/32)
    int             sctl;       // source incremental
    int             dctl;       // dest incremental
    unsigned int    stype;      // source type (0/1 => APB/AHB)
    unsigned int    dtype;      // dest type (0/1 => APB/AHB)
    unsigned int    burst;      // (0/1)==>(disable/enable)
    unsigned int    size;       // dma count
    unsigned int    irq;        // (0/1)==>(disable/enable)
} apb_dma_parm_t;

typedef struct
{
    volatile u32    *base;
    unsigned int    channel;
    unsigned int    status;
    unsigned int    hw_handshake_num;
} apb_dma_channel_data_t;

typedef struct
{
    /* init parameter */
    volatile u32    *base;
    u8              channel_used[APB_DMA_MAX_CHANNELS];
    apb_dma_channel_data_t *data[APB_DMA_MAX_CHANNELS];
    apb_dma_irq_handler_t irq_handler[APB_DMA_MAX_CHANNELS];
    void            *isr_data[APB_DMA_MAX_CHANNELS];
    u32             active_channels;
    u8  	    irq_requested;
} apb_dma_data_t;

int apb_dma_request_channel(apb_dma_irq_handler_t irq_handler, void *isr_data, int channel, apb_dma_channel_data_t **channel_data);
void apb_dma_release_channel(apb_dma_channel_data_t **channel_data);
void apb_dma_channel_add(apb_dma_channel_data_t *priv, apb_dma_parm_t *parm);
void apb_dma_channel_start(apb_dma_channel_data_t *priv);

#endif
