/*
 *  linux/include/asm-arm/map.h
 *
 *  Copyright (C) 1999-2000 Russell King
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 *  Page table mapping constructs and function prototypes
 */

#ifndef __ARM_MAPDEF_H__
#define __ARM_MAPDEF_H__

struct map_desc {
	unsigned long virtual;
	unsigned long physical;
	unsigned long length;
	unsigned int type;
};

struct meminfo;

/* Luke Lee 09/13/2005 ins 4 modes :
 *   MT_DEVICE_NCNB, MT_DEVICE_NCB, MT_DEVICE_CNB, MT_DEVICE_CB,
 *   MT_DEVICE_NCNB is euqivalent to original MT_DEVICE
 */
#define MT_DEVICE       	0
#define MT_DEVICE_NCNB  	0
#define MT_DEVICE_NCB		1
#define MT_DEVICE_CNB		2
#define MT_DEVICE_CB		3
#define MT_CACHECLEAN		4
#define MT_MINICLEAN		5
#define MT_LOW_VECTORS		6
#define MT_HIGH_VECTORS		7
#define MT_MEMORY		8
#define MT_ROM			9
#define MT_IXP2000_DEVICE       10

extern void create_memmap_holes(struct meminfo *);
extern void memtable_init(struct meminfo *);
extern void iotable_init(struct map_desc *, int);
extern void setup_io_desc(void);

#endif /* ARM_MAPDEF_H */
