#ifndef _CCR_H
#define _CCR_H

#ifdef PP_FEAT_DEVICE

/* use the original CCR defines */
#include <vsc_regs.h>

#else /* !PP_FEAT_DEVICE */

/* vsc ccr register definition,
   taken from eric_firmware/lara_kernel_modules/vsc_regs.h,
   hopefully current */

/*
 * When using LRLE encoding
 */

/* [0]     - pixel diff margin for red and blue channels */
#define CCR_LRLE_RMARGIN_RB_SHIFT	0
#define CCR_LRLE_RMARGIN_RB_MASK	(0x01 <<  CCR_LRLE_RMARGIN_RB_SHIFT)
#define CCR_LRLE_RMARGIN_RB(x)		(x << CCR_LRLE_RMARGIN_RB_SHIFT)

/* [1]     - pixel diff margin for green channel */
#define CCR_LRLE_RMARGIN_G_SHIFT	1
#define CCR_LRLE_RMARGIN_G_MASK		(0x01 <<  CCR_LRLE_RMARGIN_G_SHIFT)
#define CCR_LRLE_RMARGIN_G(x)		(x << CCR_LRLE_RMARGIN_G_SHIFT)

/* [2]     - green grey mode (instead of luminance) */
#define CCR_LRLE_GREY_GREEN_SHIFT	2
#define CCR_LRLE_GREY_GREEN_MASK	(0x01 <<  CCR_LRLE_GREY_GREEN_SHIFT)
#define CCR_LRLE_GREY_GREEN(x)		(x << CCR_LRLE_GREY_GREEN_SHIFT)

/* [3:7]   - run length limit in LRLE stage */
#define CCR_LRLE_RUNLIMIT_SHIFT 3
#define CCR_LRLE_RUNLIMIT_MASK	(0x1F <<  CCR_LRLE_RUNLIMIT_SHIFT)
#define CCR_LRLE_RUNLIMIT(x)	(x << CCR_LRLE_RUNLIMIT_SHIFT)

/* [8]     - enable line copies */
#define CCR_LRLE_LINECOPY_SHIFT 8
#define CCR_LRLE_LINECOPY_MASK	(0x01 <<  CCR_LRLE_LINECOPY_SHIFT)
#define CCR_LRLE_LINECOPY(x)	(x << CCR_LRLE_LINECOPY_SHIFT)

/* [9:12]  - grey compressor pixel diff margin */
#define CCR_LRLE_GMARGIN_SHIFT	9
#define CCR_LRLE_GMARGIN_MASK	(0x0F <<  CCR_LRLE_GMARGIN_SHIFT)
#define CCR_LRLE_GMARGIN(x)	(x << CCR_LRLE_GMARGIN_SHIFT)

/* [13]    - force grey compression */
#define CCR_LRLE_GREY_FORCE_SHIFT	13
#define CCR_LRLE_GREY_FORCE_MASK	(0x01 <<  CCR_LRLE_GREY_FORCE_SHIFT)
#define CCR_LRLE_GREY_FORCE(x)		(x << CCR_LRLE_GREY_FORCE_SHIFT)

/* [14]    - disable grey compression */
#define CCR_LRLE_GREY_DISABLE_SHIFT	14
#define CCR_LRLE_GREY_DISABLE_MASK	(0x01 <<  CCR_LRLE_GREY_DISABLE_SHIFT)
#define CCR_LRLE_GREY_DISABLE(x)	(x << CCR_LRLE_GREY_DISABLE_SHIFT)

/* [15:18] - color reduction mode */
#define CCR_LRLE_COLOR_SHIFT	15
#define CCR_LRLE_COLOR_MASK	(0x0F << CCR_LRLE_COLOR_SHIFT)
#define CCR_LRLE_COLOR(x)	(x << CCR_LRLE_COLOR_SHIFT)

#define LRLE_COLOR_1BIT_GREY	0x00
#define LRLE_COLOR_2BIT_GREY	0x01
#define LRLE_COLOR_3BIT_GREY	0x02
#define LRLE_COLOR_4BIT_GREY	0x03
#define LRLE_COLOR_5BIT_GREY	0x04
#define LRLE_COLOR_6BIT_GREY	0x05
#define LRLE_COLOR_7BIT_GREY	0x06
#define LRLE_COLOR_8BIT_GREY	0x07
#define LRLE_COLOR_15BIT_DIRECT	0x08
#define LRLE_COLOR_7BIT_DIRECT	0x09
#define LRLE_COLOR_4BIT_PALETTE	0x0A

/* [19]    - linecopy margin for red and blue channels */
#define CCR_LRLE_CMARGIN_RB_SHIFT	19
#define CCR_LRLE_CMARGIN_RB_MASK	(0x01 <<  CCR_LRLE_CMARGIN_RB_SHIFT)
#define CCR_LRLE_CMARGIN_RB(x)		(x << CCR_LRLE_CMARGIN_RB_SHIFT)

/* [20]    - linecopy margin for green channel */
#define CCR_LRLE_CMARGIN_G_SHIFT	20
#define CCR_LRLE_CMARGIN_G_MASK		(0x01 <<  CCR_LRLE_CMARGIN_G_SHIFT)
#define CCR_LRLE_CMARGIN_G(x)		(x << CCR_LRLE_CMARGIN_G_SHIFT)

/* [21:24] - FREE */

/* [25-29] - run length limit in reaccumulator stage */
#define CCR_LRLE_REACC_RUNLIMIT_SHIFT	25
#define CCR_LRLE_REACC_RUNLIMIT_MASK	(0x1F <<  CCR_LRLE_REACC_RUNLIMIT_SHIFT)
#define CCR_LRLE_REACC_RUNLIMIT(x)	(x << CCR_LRLE_REACC_RUNLIMIT_SHIFT)

/*
 * When using Downsampling encoding
 */

/* [0:1] - downsampling mode, how many pixels to interpolate */
#define CCR_DOWN_MODE_SHIFT             0
#define CCR_DOWN_MODE_MASK              (0x03 <<  CCR_DOWN_MODE_SHIFT)
#define CCR_DOWN_MODE(x)                ((x) << CCR_DOWN_MODE_SHIFT)

#define DOWN_MODE_1X1                   0
#define DOWN_MODE_2X2                   1
#define DOWN_MODE_4X4                   2
#define DOWN_MODE_8X8                   3

/*
 * Always available, regardless of the encoding
 */

/* [30-31] - compression algorithm */
#define CCR_VSC_ALGO_SHIFT	30
#define CCR_VSC_ALGO_MASK	(0x03 << CCR_VSC_ALGO_SHIFT)
#define CCR_VSC_ALGO(x)		(x << CCR_VSC_ALGO_SHIFT)

#define VSC_ALGO_NULL		0x00
#define VSC_ALGO_LRLE		0x01
#define VSC_ALGO_DOWNSAMPLE	0x02
#define VSC_ALGO_DCT		0x03

#endif /* !PP_FEAT_DEVICE */

#endif /* _CCR_H */
