#!/usr/bin/perl -w
###############################################################################
#
#      cryptpasswd.pl
#        use to replace a password from passwd
#

use strict;

#
###############################################################################
# imports
#

use Getopt::Std;

my $opts  = {};

my $usage =
  "Usage: \n\n" .
  "  cryptpasswd.pl -f <filename> -u <username> -p <password> \n\n" .
  "    -f <filename>     - passwd file to change\n" .
  "    -u <username>     - the user entry to change the password for\n" .
  "    -p <password>     - the new password\n\n";

#
###############################################################################
# main program
#

getopts('f:u:p:', $opts);

defined $opts->{f} or die "Please enter a passwd filename\n\n$usage";
defined $opts->{u} or die "Please enter a username to change password for\n\n$usage";

my $filename = $opts->{f};
my $username = $opts->{u};
my $password;
my $line;
my @passwd_file;
my @chars = ( "A" .. "Z", "a" .. "z", 0 .. 9 );
my $salt  = join("", @chars[ map { rand @chars } ( 1 .. 8 ) ]);

if (defined($opts->{p})) {
	$password = $opts->{p};
} else {
	$password = "";
}
my $encrypted = crypt($password, $salt);

open FILE, $filename or die "Error: Can't open '$filename' for reading. ($!)\n";
@passwd_file = <FILE>;
close FILE;

open FILE, ">$filename" or die "Error: Can't open '$filename' for writing. ($!)\n";
foreach $line (@passwd_file) {
	$line =~ s/^root:.*?:/root:$encrypted:/;
	print FILE $line;
}
close FILE;

