(define (nn-pp-rc1button-init)
    ;initialize the global nn-pp-variables
    (set! nn-pp-button-no 0)
    (set! nn-pp-button-text '())
    (set! nn-pp-button-filename '())
)

(define (nn-pp-rc1button-add text out_filename)
    ;increase the number of buttons
    (set! nn-pp-button-no (+ nn-pp-button-no 1))
    ;add the strings to the lists
    (set! nn-pp-button-text (cons text nn-pp-button-text))
    (set! nn-pp-button-filename (cons out_filename nn-pp-button-filename))
)

(define (nn-pp-rc1buttons font textcolor text_opacity use_textshadow shadow_opacity text_scaling left_filename middle_filename right_filename)
    (while (> nn-pp-button-no 0)
        (set! nn-pp-button-no (- nn-pp-button-no 1))
        (set! text (car nn-pp-button-text))
        (set! filename (car nn-pp-button-filename))
        (set! nn-pp-button-text (cdr nn-pp-button-text))
        (set! nn-pp-button-filename (cdr nn-pp-button-filename))
        (nn-pp-build-rc1button text font textcolor text_opacity use_textshadow shadow_opacity text_scaling left_filename middle_filename right_filename filename)
    )
)

(define (nn-pp-build-rc1button text font textcolor text_opacity use_textshadow shadow_opacity text_scaling left_filename middle_filename right_filename out_filename)
    ; create a new image for the button
    (set! img (car (gimp-image-new 512 256 RGB)))
    (set! imgtext (car (gimp-image-new 4096 256 RGB)))
    (set! imgtextshadow (car (gimp-image-new 4096 256 RGB)))
    
    ; open the left and right part of the button and the template for the middle
    (set! imgleft (car (file-gif-load 0 left_filename left_filename)))
    (set! imgmiddle (car (file-gif-load 0 middle_filename middle_filename)))
    (set! imgright (car (file-gif-load 0 right_filename right_filename)))
    
    ; get size of the left and right button part
    (set! height_left (car (gimp-image-height imgleft)))
    (set! width_left (car (gimp-image-width imgleft)))
    (set! width_right (car (gimp-image-width imgright)))
    
    ; create text 
    (set! size 50)
    (set! border -1)
    (set! textshadow 2)
    (gimp-palette-set-foreground textcolor)
    (set! text-layer (car (gimp-text imgtext -1 0 0 text border TRUE size PIXELS "*" font "*" "*" "*" "*" "*" "*")))
    (gimp-palette-set-foreground '(0 0 0))
    (set! textshadow-layer (car (gimp-text imgtextshadow -1 0 0 text border TRUE size PIXELS "*" font "*" "*" "*" "*" "*" "*")))
    
    ; get the dimension of the text
    (set! old_width_text (car (gimp-drawable-width text-layer)))
    (set! old_height_text (car (gimp-drawable-height text-layer)))
    
    ; get the dimension of the whole button
    (set! height_text (/ (* height_left text_scaling) 100))
    (set! width_text (* height_text (/ old_width_text old_height_text)))
    (set! width (+ textshadow width_text width_left width_right))
    (set! height height_left)
    
    ; adjust the button size to multiples of 32, at least 64
    (set! mult-width 68)
    (set! new-width 0)
    (while (< new-width width)
        (set! new-width (+ new-width mult-width))
    )
    (set! width new-width)
    
    ; resize the text image
    (gimp-image-resize imgtext old_width_text old_height_text 0 0)
    (gimp-image-scale imgtext width_text height_text)
    (gimp-image-resize imgtextshadow old_width_text old_height_text 0 0)
    (gimp-image-scale imgtextshadow width_text height_text)
    
    ;resize the main image
    (gimp-image-resize img width height 0 0)

    ; create bg layer
    (set! bg-layer (car (gimp-layer-new img width height RGBA-IMAGE "Background" 100 NORMAL)))
    
    ; set the layers to the image
    (gimp-image-undo-disable img)
    (gimp-image-add-layer img bg-layer 1)
    
    ; clear the background
    (gimp-selection-none img)
    (gimp-edit-clear bg-layer)
    
    ; copy the left button part
    (gimp-selection-all imgleft)
    (set! from_layer (car (gimp-image-get-active-layer imgleft)))
    (gimp-edit-copy from_layer)
    (set! act_layer (car (gimp-image-get-active-layer img)))
    (set! left_layer (car (gimp-edit-paste act_layer 0)))
    (set! draw_left_width (car (gimp-drawable-width left_layer)))
    (gimp-layer-set-offsets left_layer 1 1)
    
    ; copy the right button part
    (gimp-selection-clear img)
    (gimp-selection-all imgright)
    (set! from_layer (car (gimp-image-get-active-layer imgright)))
    (gimp-edit-copy from_layer)
    (set! right_layer (car (gimp-edit-paste act_layer 0)))
    (set! draw_right_width (car (gimp-drawable-width right_layer)))
    (gimp-layer-set-offsets right_layer (- width draw_right_width 1) 1)
    
    ; fill the middle button background
    (set! width_middle (- width draw_left_width draw_right_width 2))
    (gimp-image-scale imgmiddle width_middle height_left)
    (gimp-selection-clear img)
    (gimp-selection-all imgmiddle)
    (set! from_layer (car (gimp-image-get-active-layer imgmiddle)))
    (gimp-edit-copy from_layer)
    (set! middle_layer (car (gimp-edit-paste act_layer 0)))
    (gimp-layer-set-offsets middle_layer (+ draw_left_width 1) 1)
    
    ; copy the text shadow
    (if (> use_textshadow 0)
        (begin
            (gimp-selection-clear img)
            (gimp-selection-all imgtextshadow)
            (set! from_layer (car (gimp-image-get-active-layer imgtextshadow)))
            (gimp-edit-copy from_layer)
            (set! textshadow_layer (car (gimp-edit-paste act_layer 0)))
            (gimp-layer-set-opacity textshadow_layer shadow_opacity)
            (gimp-layer-translate textshadow_layer textshadow textshadow)
        )
    )

    ; copy the text
    (gimp-selection-clear img)
    (gimp-selection-all imgtext)
    (set! from_layer (car (gimp-image-get-active-layer imgtext)))
    (gimp-edit-copy from_layer)
    (set! text_layer (car (gimp-edit-paste act_layer 0)))
    (gimp-layer-set-opacity text_layer text_opacity)
    
    ;save the image as gif
    (set! merged_layer (car (gimp-image-merge-visible-layers img 0)))
    (gimp-image-convert-indexed img NO-DITHER MAKE-PALETTE 255 0 0 "rc1")
    (file-gif-save 1 img merged_layer out_filename out_filename 0 0 0 0)

    ;debugging in the gimp UI: show the image
    ;(gimp-display-new img)
    ;(gimp-image-undo-enable img)
)
