#ifndef _CPE_H
#define _CPE_H

/*
 * Include hardware definitions.
 */
#include "hw_20.h"

/*
 * Generic macro for getting hardware id specific values.
 *
 * NOTES: - Hardware ids are always two characters wide - possibly
 *	    with leading zeros.
 *
 *	  - The routine is wrapped to ensure that the arguments get
 *          expanded first.
 *
 *	  - The "name" parameter must not be macro expanded!
 */
#define PP_(name, hwid) __PP_PREFIX(_##name, hwid)
#define __PP_PREFIX(name, hwid) PP_HWID_##hwid##name

/*
 * Texttual description of the hardware
 *
 * NOTES: - Hardware ids are always two characters wide - possibly
 *	    with leading zeros.
 *
 *	  - The routine is wrapped to ensure that the arguments get
 *          expanded first.
 */
#define PP_HW_DESCRIPTION(hwid) __PP_HW_DESCRIPTION(hwid)
#define __PP_HW_DESCRIPTION(hwid) PP_HWID_##hwid##_DESCRIPTION

#endif /* _CPE_H */
