/**
 * Power Management Unit Pin Multiplexer
 * Initialize board-specific defaults for the PMU Pin Mux Register
 * 
 * (c) 2005 Peppercon AG, Michael Baumann <miba@peppercon.de>
 */

#include <linux/types.h>
#include <kira/cpe.h>
#include <kira/kira100.h>
#include <kira/kira_init.h>

#define TACHO_7_GPIO31_IS_GPIO		1
#define TACHO_6_GPIO30_IS_GPIO		1
#define TACHO_5_GPIO29_IS_GPIO		1
#define TACHO_4_GPIO28_IS_GPIO		1
#define TACHO_3_GPIO27_IS_GPIO		1
#define TACHO_2_GPIO26_IS_GPIO		1
#define TACHO_1_GPIO25_IS_GPIO		1
#define TACHO_0_GPIO24_IS_GPIO		1
#define PWM_7_GPIO23_IS_GPIO		1
#define PWM_6_GPIO22_IS_GPIO		1
#define PWM_5_GPIO21_IS_GPIO		1
#define PWM_4_GPIO20_IS_GPIO		1
#define PWM_3_GPIO19_IS_GPIO		1
#define PWM_2_GPIO18_IS_GPIO		1
#define PWM_1_GPIO17_IS_GPIO		1
#define PWM_0_GPIO16_IS_GPIO		1
#define PMU_REG_PORT_MUX_CONTENT	((TACHO_7_GPIO31_IS_GPIO << 31) | \
					 (TACHO_6_GPIO30_IS_GPIO << 30) | \
					 (TACHO_5_GPIO29_IS_GPIO << 29) | \
					 (TACHO_4_GPIO28_IS_GPIO << 28) | \
					 (TACHO_3_GPIO27_IS_GPIO << 27) | \
					 (TACHO_2_GPIO26_IS_GPIO << 26) | \
					 (TACHO_1_GPIO25_IS_GPIO << 25) | \
					 (TACHO_0_GPIO24_IS_GPIO << 24) | \
					 (PWM_7_GPIO23_IS_GPIO   << 23) | \
					 (PWM_6_GPIO22_IS_GPIO	 << 22) | \
					 (PWM_5_GPIO21_IS_GPIO	 << 21) | \
					 (PWM_4_GPIO20_IS_GPIO	 << 20) | \
					 (PWM_3_GPIO19_IS_GPIO	 << 19) | \
					 (PWM_2_GPIO18_IS_GPIO	 << 18) | \
					 (PWM_1_GPIO17_IS_GPIO	 << 17) | \
					 (PWM_0_GPIO16_IS_GPIO	 << 16))

void
kira_init_pinmux(void)
{
    volatile u_int32_t *pmu_regs = (u_int32_t*) CPE_PMU_BASE;
    u_int32_t mux_val = PMU_REG_PORT_MUX_CONTENT;
    unsigned int kira_rev;

    kira_rev = kira_get_revision();

    if (KIRA_MAJOR(kira_rev) > 1) {
	/* KIRA R02 has the meaning of the GPIO pin mux swapped */
	mux_val = ~mux_val;
    }

    pmu_regs[KIRA_PMU_REG_PORTMUX] = mux_val;
}
