/*
 * (C) Copyright 2002
 * Gary Jennejohn, DENX Software Engineering, <gj@denx.de>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

#include <asm/u-boot.h>
#include "arm940t.h"
#include "kira/symbol.h"
#include "kira/porting.h"
#include "kira/serial.h"
#include <common.h>

// --------------------------------------------------------------------
//		librarys copy from flib
// --------------------------------------------------------------------

#ifdef CONFIG_SERIAL1
	UINT32 DebugSerialPort = CPE_UART1_BASE;
#elif CONFIG_SERIAL2
	UINT32 DebugSerialPort = CPE_UART2_BASE;
#else
	#error "Bad: you didn't configure serial ..."
#endif


unsigned int br[] = {1562, 780, 390, 194, 32, 15};
void serial_setbrg(void)
{
	unsigned int reg = 0;
        DECLARE_GLOBAL_DATA_PTR;
	
	unsigned int baudrate = gd->baudrate;
	
	if (baudrate == 9600)
	{
		reg = CPE_BAUD_9600;
	}
	else if (baudrate == 19200)
	{
		reg = CPE_BAUD_19200;
	}
	else if (baudrate == 38400)
	{
		reg = CPE_BAUD_38400;
	}
	else if (baudrate == 57600)
	{
		reg = CPE_BAUD_57600;
	}
	else if (baudrate == 115200)
	{
		reg = CPE_BAUD_115200;
	}
	else
	{
		hang();
	}

	fLib_SetSerialMode( DebugSerialPort, SERIAL_MDR_UART );
	fLib_SerialInit( DebugSerialPort, reg, PARITY_NONE, 0, 8 );
	fLib_SetSerialFifoCtrl(DebugSerialPort, 1, ENABLE, ENABLE);
	
}

/*
 * Initialise the serial port with the given baudrate. The settings
 * are always 8 data bits, no parity, 1 stop bit, no start bits.
 *
 */
int serial_init(void)
{

    serial_setbrg();

    return 0;
}

/*
 * Read a single byte from the serial port. Returns 1 on success, 0
 * otherwise. When the function is succesfull, the character read is
 * written into its argument c.
 */
int serial_getc(void)
{
	return fLib_GetSerialChar( DebugSerialPort ); 
}

void serial_puts (const char *s)
{
            while (*s) {
		                serial_putc (*s++);
				        }
}

/*
 * Output a single byte to the serial port.
 */
void serial_putc(const char c)
{
#ifdef CONFIG_PEPPERCON
    DECLARE_GLOBAL_DATA_PTR;
    
    if (gd->pp.serial_debug) {
#endif
	
	fLib_PutSerialChar( DebugSerialPort, c );
	
	/* If \n, also do \r */
	if(c == '\n')
	    serial_putc('\r');
#ifdef CONFIG_PEPPERCON
    }
#endif
}
    
/*
 * Test whether a character is in the RX buffer
 */
int serial_tstc(void)
{
    int x;
 	x = ( cpe_inl( DebugSerialPort + SERIAL_LSR ) & SERIAL_LSR_DR ) == SERIAL_LSR_DR;
	return x;
}

