/* ------------------------------------------------------------------------- */
/*       This source code has been made available to you by IBM on an AS-IS  */
/*       basis.  Anyone receiving this source is licensed under IBM          */
/*       copyrights to use it in any way he or she deems fit, including      */
/*       copying it, modifying it, compiling it, and redistributing it either*/
/*       with or without modifications.  No license under IBM patents or     */
/*       patent applications is to be implied by the copyright license.      */
/*                                                                           */
/*       Any user of this software should understand that IBM cannot provide */
/*       technical support for this software and will not be responsible for */
/*       any consequences resulting from the use of this software.           */
/*                                                                           */
/*       Any person who transfers this source code or any derivative work    */
/*       must include the IBM copyright notice, this paragraph, and the      */
/*       preceding two paragraphs in the transferred software.               */
/*                                                                           */
/*       COPYRIGHT   I B M   CORPORATION 1995                                */
/*       LICENSED MATERIAL  -  PROGRAM PROPERTY OF I B M                     */
/* ------------------------------------------------------------------------- */

/* ------------------------------------------------------------------------- */
/* Function:     ext_bus_cntlr_init					     */
/* Description:  Initializes the External Bus Controller for the external    */
/*		peripherals. IMPORTANT: For pass1 this code must run from    */
/*		cache since you can not reliably change a peripheral banks   */
/*		timing register (pbxap) while running code from that bank.   */
/*		For ex., since we are running from ROM on bank 0, we can NOT */
/*		execute the code that modifies bank 0 timings from ROM, so   */
/*		we run it from cache.                                        */
/*                                                                           */
/* ------------------------------------------------------------------------- */

#include <config.h>
#include <ppc4xx.h>

#include <ppc_asm.tmpl>
#include <ppc_defs.h>

#include <asm/cache.h>
#include <asm/mmu.h>

	.globl  ext_bus_cntlr_init
ext_bus_cntlr_init:
	mflr	r4		/* save link register */
	bl	..getAddr
..getAddr:
	mflr	r3		/* get address of ..getAddr */
	mtlr	r4		/* restore link register */
	addi	r4,0,14		/* set ctr to 10; used to prefetch */
	mtctr	r4		/* 10 cache lines to fit this function */
				/* in cache (gives us 8x10=80 instrctns) */
..ebcloop:
	icbt	r0,r3		/* prefetch cache line for addr in r3 */
	addi	r3,r3,32	/* move to next cache line */
	bdnz	..ebcloop	/* continue for 10 cache lines */

	/* ----------------------------------------------------------------- */
	/* Delay to ensure all accesses to ROM are complete before changing  */
	/* bank 0 timings. 200usec should be enough.			     */
	/*   200,000,000 (cycles/sec) X .000200 (sec) = 0x9C40 cycles	     */
	/* ----------------------------------------------------------------- */
	addis	r3,0,0x0
	ori	r3,r3,0xA000	/* ensure 200usec have passed since reset */
        mtctr   r3
..spinlp:
	bdnz	..spinlp	/* spin loop */

	/* ----------------------------------------------------------------- */
        /* Set EBC Configuration register				     */
        /* ----------------------------------------------------------------- */

	addi    r4,0,epcr
        mtdcr   ebccfga,r4
	addis   r4,0,PP_CALC_EBC0_CFG(PP_HWID)@h
	ori     r4,r4,PP_CALC_EBC0_CFG(PP_HWID)@l
        mtdcr   ebccfgd,r4

        /* ----------------------------------------------------------------- */
        /* Memory Bank 0 (Flash) initialization (from openbios)		     */
        /* ----------------------------------------------------------------- */

        addi    r4,0,pb0ap
        mtdcr   ebccfga,r4
	addis   r4,0,PP_CALC_EBC0_BnAP(PP_HWID,00)@h
	ori     r4,r4,PP_CALC_EBC0_BnAP(PP_HWID,00)@l
        mtdcr   ebccfgd,r4

        addi    r4,0,pb0cr
        mtdcr   ebccfga,r4
	addis   r4,0,PP_CALC_EBC0_BnCR(PP_HWID,00)@h
	ori     r4,r4,PP_CALC_EBC0_BnCR(PP_HWID,00)@l
        mtdcr   ebccfgd,r4

	nop			/* pass2 DCR errata #8 */
        blr

/* ------------------------------------------------------------------------- */
/* Function:     sdram_init						     */
/* Description:  Dummy implementation here - done in C later		     */
/* ------------------------------------------------------------------------- */
	.globl  sdram_init
sdram_init:
        mflr    r31
        
	/* ----------------------------------------------------------------- */
	/* Set MB0CF for bank 0.					     */
	/* ----------------------------------------------------------------- */

        addi    r4,0,mem_mb0cf
        mtdcr   memcfga,r4
        addis   r4,0,PP_(SDRAM_B0CR,PP_HWID)@h
        ori     r4,r4,PP_(SDRAM_B0CR,PP_HWID)@l
        mtdcr   memcfgd,r4

        /* ----------------------------------------------------------------- */
	/* Set SDTR1							     */
        /* ----------------------------------------------------------------- */
        addis   r6,0,PP_(SDRAM_TR,PP_HWID)@h
        ori     r6,r6,PP_(SDRAM_TR,PP_HWID)@l
        addi    r4,0,mem_sdtr1
        mtdcr   memcfga,r4
        mtdcr   memcfgd,r6

	/* ----------------------------------------------------------------- */
	/* Set RTR							     */
	/* ----------------------------------------------------------------- */
        addis   r7,0,PP_(SDRAM_RTR,PP_HWID)
        addi    r4,0,mem_rtr
        mtdcr   memcfga,r4
        mtdcr   memcfgd,r7

	/* ----------------------------------------------------------------- */
	/* Delay to ensure all accesses to ROM are complete before changing  */
	/* bank 0 timings. 200usec should be enough.			     */
	/*   200,000,000 (cycles/sec) X .000200 (sec) = 0x9C40 cycles	     */
	/* ----------------------------------------------------------------- */
	addis	r3,0,0x0
	ori	r3,r3,0xA000	/* ensure 200usec have passed since reset */
        mtctr   r3
..spinlp2:
	bdnz	..spinlp2	/* spin loop */

	/* ----------------------------------------------------------------- */
	/* Set memory controller options reg, MCOPT1.			     */
	/* Set DC_EN to '1' and BRD_PRF to '01' for 16 byte PLB Burst	     */
	/* read/prefetch.						     */
	/* ----------------------------------------------------------------- */
        addi    r4,0,mem_mcopt1
        mtdcr   memcfga,r4
        addis   r4,0,0x8080	/* set DC_EN=1 */
        ori     r4,r4,0x0000
        mtdcr   memcfgd,r4

	/* ----------------------------------------------------------------- */
	/* Delay to ensure 10msec have elapsed since reset. This is	     */
	/* required for the MPC952 to stabalize. Assume worst		     */
	/* case that the core is running 200Mhz:			     */
	/* 200,000,000 (cycles/sec) X .010 (sec) = 0x1E8480 cycles	     */
	/* This delay should occur before accessing SDRAM.		     */
	/* ----------------------------------------------------------------- */
        addis   r3,0,0x001E
        ori     r3,r3,0x8480	/* ensure 10msec have passed since reset */
        mtctr   r3
..spinlp3:
        bdnz    ..spinlp3	/* spin loop */

        mtlr    r31		/* restore lr */
        blr
