/*****************************************************************************
 *  This file contains Validation Checks
 *
 *  FILE: check.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>


/*-----------------------------------------------------------------------------
 * i2c address validation
 *---------------------------------------------------------------------------*/
int check_i2caddr( ulong addr )
{
    if (addr > 0xFF) {
       printf("\nERROR: Invalid I2C address 0x%08lx\n", addr);
       printf("Valid I2C address range is 0x00 - 0x7f.\n");
       return -1;
    }
    return 0;
}

/*-----------------------------------------------------------------------------
 * flash sector validation
 *---------------------------------------------------------------------------*/
int check_flashsect( ulong sector )
{
    /* info for FLASH chips */
    extern flash_info_t flash_info[];

    if (sector >= flash_info[0].sector_count) {
       printf("\nERROR: Invalid flash sector %d\n", (int)sector);
       printf("Valid flash sector is 0 - %d.\n", 
              flash_info[0].sector_count - 1);
       return -1;
    }
    return 0;
}

/*-----------------------------------------------------------------------------
 * flash bank validation
 *---------------------------------------------------------------------------*/
int check_flashbank( ulong bank )
{
    if (bank >= CFG_MAX_FLASH_BANKS) {
       printf("\nERROR: Invalid flash bank %d\n", (int)bank);
       printf("Valid flash bank is 0 - %d.\n", CFG_MAX_FLASH_BANKS - 1);
       return -1;
    }
    return 0;
}

/*-----------------------------------------------------------------------------
 * byte width access validation
 *---------------------------------------------------------------------------*/
int check_byte_width( ulong width )
{
    switch (width) {
       case (sizeof(uchar)):  /* 1 */
       case (sizeof(ushort)): /* 2 */
       case (sizeof(ulong)):  /* 4 */
          break;
       default:
          printf("\nERROR: Invalid byte width specified!\n");
          printf("Valid values are 1 (8-bit), 2 (16-bit), and 4 (32-bit).\n");
          return -1;
    }
    return 0;
}
