/*****************************************************************************
 *  Diagnostics Menu
 *
 *  FILE: diag_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <diag_menu.h>
#include <memory_menu.h>
#include <ether_menu.h>
#include <util.h>

static void print_diag_menu( void )
{
    int i = 1;

    printf("\nDiagnostics:");
    print_exit();
    printf("\n\t %d: Memory Test", i++);
    printf("\n\t %d: Ethernet Test", i++);
    printf("\n\n");

    return;
}

int diag_menu( void )
{
    char diag_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long diag_opt;
    int opt_res;

    while (diag_flag) {
        print_diag_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case DIAG_MENU_EXIT:
                diag_flag = 0;
                break;

            case MEMORY_TEST:
                result = memory_test_menu();
                break;

            case ETHERNET_TEST:
                result = ether_menu();
                break;

            default:
                print_invalid();
                break;
        }

        if( result == 0 ) {
            diag_flag = 0;
        }
    }

    return result;
}
