/*****************************************************************************
 *  Davicom DM9161 PHY-specific interface functions
 *
 *  FILE: dm9161.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <mii_phy.h>
#include <miiphy.h>
#include <dm9161.h>
#include <dm9161a.h>


static void
mii_phy_print_regval(unsigned short reg, unsigned short val)
{
   switch (reg) {
      case PHY_BMCR:
         printf("Control                           (0): 0x%04x\n", val);
         break;
      case PHY_BMSR:
         printf("Status                            (1): 0x%04x\n", val);
         break;
      case PHY_PHYIDR1:
         printf("PHY Identification 1              (2): 0x%04x\n", val);
         break;
      case PHY_PHYIDR2:
         printf("PHY Identification 2              (3): 0x%04x\n", val);
         break;
      case PHY_ANAR:
         printf("Auto-Negotiation Advertisement    (4): 0x%04x\n", val);
         break;
      case PHY_ANLPAR:
         printf("Auto-Negotiation Link Par Ability (5): 0x%04x\n", val);
         break;
      case PHY_ANER:
         printf("Auto-Negotiation Expansion        (6): 0x%04x\n", val);
         break;
      case DM9161_DSCR:
         printf("Specified Configuration           (16): 0x%04x\n", val);
         break;
      case DM9161_DSCSR:
         printf("Secified Configuration and Status (17): 0x%04x\n", val);
         break;
      case DM9161_10BTCSR:
         printf("10BASE-T Configuration/Status     (18): 0x%04x\n", val);
         break;
      case DM9161_MDINTR:
         printf("Specified Interrupt               (21): 0x%04x\n", val);
         break;
      case DM9161_RECR:
         printf("Specified Rx Error Counter        (22): 0x%04x\n", val);
         break;
      case DM9161_DISCR:
         printf("Specified Disconnect Counter      (23): 0x%04x\n", val);
         break;
      case DM9161_RLSR:
         printf("HW Reset Latch State              (24): 0x%04x\n", val);
         break;
      default:
         printf("Invalid Register %d\n", reg);
         break;
   }

   return;
}

void
mii_phy_read_all_regs(void)
{
    unsigned short regval, addr;

    for (addr = 0; addr < 6; addr++) {
        regval = mii_phy_read(addr);
        mii_phy_print_regval(addr, regval);
    }
    for (addr = 16; addr < 18; addr++) {
        regval = mii_phy_read(addr);
        mii_phy_print_regval(addr, regval);
    }
    for (addr = 21; addr < 24; addr++) {
        regval = mii_phy_read(addr);
        mii_phy_print_regval(addr, regval);
    }

    return;
}

void
mii_phy_get_status(void)
{
   unsigned short bmsr, bmcr, dscsr, btcsr10;

   /* control register (addr 0) */
   bmcr = mii_phy_read(PHY_BMCR);

   /* status register 1 (addr 1) */
   bmsr = mii_phy_read(PHY_BMSR);

   /* Specified Status (addr 17) */
   dscsr = mii_phy_read(DM9161_DSCSR);

   /* 10BASE-T Status (addr 18) */
   btcsr10 = mii_phy_read(DM9161_10BTCSR);

   printf("Link Status      : %s\n",
          (bmsr & PHY_BMSR_LS)?"link up":"link down");
   printf("10/100 Mode      : ");
   if(dscsr & DM9161_100FDX || dscsr & DM9161_100HDX) {
       printf("100Mbs\n");
   }
   else {
       printf("10Mbs\n");
   }
   printf("Duplex Mode      : ");
   if(dscsr & DM9161_100FDX || dscsr & DM9161_10FDX) {
       printf("Full\n");
   }
   else {
       printf("Half\n");
   }
   printf("Auto-Neg Mode    : %s\n", (bmcr & PHY_BMCR_AUTON)?"yes":"no");
   if(bmcr & PHY_BMCR_AUTON) {
       printf("Auto-Neg Complete: %s\n", (bmsr & PHY_BMSR_AUTN_COMP)?"yes":"no");
       printf("Auto-Neg Monitor : ");
       switch( dscsr & DM9161_ANMB ) {
           case 0:
               printf("idle");
               break;
           case 1:
               printf("ability match");
               break;
           case 2:
               printf("ack match");
               break;
           case 3:
               printf("ack match fail");
               break;
           case 4:
               printf("consistency match");
               break;
           case 5:
               printf("consistency match fail");
               break;
           case 6:
               printf("signal link rdy");
               break;
           case 7:
               printf("signal link rdy fail");
               break;
           case 8:
               printf("complete");
               break;
           default:
               printf("unknown");
               break;
       }
       printf("\n");
   }
   printf("Polarity         : %s\n", (btcsr10 & DM9161_POLR)?"reverse":"normal");
   printf("Jabber Detected  : %s\n\n", (bmsr & PHY_BMSR_JD)?"yes":"no");

   return;
}

int
mii_phy_config_led_disp(ushort led, ushort disp)
{
    ushort dscr;

    dscr = mii_phy_read(DM9161_DSCR);

    switch(disp) {
        case LED_DISP_SPEED:
            dscr |= DM9161_SPLED_CTL;
            break;

        case LED_DISP_SPEED_OFF:
            dscr &= ~DM9161_SPLED_CTL;
            break;

        case LED_DISP_DUPLEX:
            dscr &= ~DM9161_COLLED_CTL;
            break;

        case LED_DISP_DUPLEX_CLSN:
            dscr |= DM9161_COLLED_CTL;
            break;

        default:
            return -2;
    }

    mii_phy_write(DM9161_DSCR, dscr);

    return 0;
}

int
mii_phy_config_led_freq(ushort pulse_stretch)
{
    return 0;
}

void
mii_phy_config_led_ps(ushort ps)
{
    return;
}
