/*****************************************************************************
 *  MII PHY Utilities Menu
 *
 *  FILE: eeprom_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_EEPROM)

#include <eeprom_menu.h>
#include <util.h>
#include <rtl8169.h>


#ifdef DEBUG
#define DBG(x...)       printf(x)
#else /* DEBUG */
#define DBG(x...)       do { } while(0)
#endif /* DEBUG */

static void print_eeprom_menu( void );

static void print_eeprom_menu( void )
{
    int i = 1;

    printf("\nGE EEPROM Utilities:");
    print_exit();
    printf("\n\t %d: Read GE EEPROM MAC address", i++);
    printf("\n\t %d: Write GE EEPROM MAC address", i++);
    printf("\n\n");

    return;
}

int eeprom_menu( void )
{
    char menu_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long diag_opt;
    int opt_res;
    int num_chars;
#if 0
    unsigned long val;
    int auton, linkopt;
#endif

    while (menu_flag && result != 0) {
	print_eeprom_menu();

	opt_res = menu_get_user_input(&diag_opt);
	if( opt_res > 0 ) {
	    return 0;
	}
	else if( opt_res < 0 ) {
	    continue;
	}

	switch( diag_opt ) {
	    case EEPROM_MENU_EXIT:
		menu_flag = 0;
		break;

	    case EEPROM_MENU_READ_REG:
		{
		    union {
			unsigned char byte[6];
			u16 halfword[3];
		    } mac;
		    mac.halfword[0] = rtl_read_eeprom( RTL_EEPROM_MAC_OFFSET );
		    mac.halfword[1] = rtl_read_eeprom( RTL_EEPROM_MAC_OFFSET+1 );
		    mac.halfword[2] = rtl_read_eeprom( RTL_EEPROM_MAC_OFFSET+2 );
		    printf( "EEPROM MAC %02x:%02x:%02x:%02x:%02x:%02x\n",
			    mac.byte[0], mac.byte[1], mac.byte[2], 
			    mac.byte[3], mac.byte[4], mac.byte[5] );
		}
		break;

	    case EEPROM_MENU_WRITE_REG:
		{
		    int idx;
		    union {
			unsigned char byte[6];
			u16 halfword[3];
		    } mac;
		    char eth[128];
		    char *end_cptr, *cptr = eth;

		    num_chars = readline("\nEnter MAC address: ");
		    strncpy(eth, console_buffer, num_chars);
		    for (idx = 0; idx < 6; ++idx) {
			mac.byte[idx] = cptr ? simple_strtoul (cptr, &end_cptr, 16) : 0;
			if (cptr)
                                cptr = (*end_cptr) ? end_cptr + 1 : end_cptr;
		    }
		    DBG( "MAC bytes %02x:%02x:%02x:%02x:%02x:%02x\n",
			    mac.byte[0], mac.byte[1], mac.byte[2],
			    mac.byte[3], mac.byte[4], mac.byte[5] );
		    rtl_write_eeprom(RTL_EEPROM_MAC_OFFSET, mac.halfword[0]);
		    rtl_write_eeprom(RTL_EEPROM_MAC_OFFSET+1, mac.halfword[1]);
		    rtl_write_eeprom(RTL_EEPROM_MAC_OFFSET+2, mac.halfword[2]);
		}
		break;

	    default:
		print_invalid();
		break;
	}
    }

    return result;
}


#endif /* (CFG_RARITAN_UTIL_EEPROM) */
