/*****************************************************************************
 *  LCD/ADC Controller Utilities Menu
 *
 *  FILE: lcd_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_LCD)

#include <lcd_menu.h>
#include "lcd_raritan.h"
#include <util.h>
#include <ad9888.h>


static void print_lcd_menu( void )
{
    int i = 1;

    printf("\nVideo Controller Utility:");
    print_exit();
    printf("\n\t %d: Select Video Controller", i++);
    printf("\n\t %d: Read All  AD9888 Register", i++);
    printf("\n\t %d: Read Register", i++);
    printf("\n\t %d: Write Register", i++);
    printf("\n\n");

    return;
}

int check_lcd( ulong lcd )
{
    if (lcd >= lcd_get_ndev()) {
        printf("ERROR: Invalid LCD id!\n");
        return -1;
    }
    return 0;
}

static int check_regaddr( ulong reg )
{
    if (reg > 0x19) {
        printf("Invalid AD9888 Register!\n");
        return -1;
    }

    /* register address is ok */
    return 0;
}

int lcd_menu( void )
{
    char lcd_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    int nchars;
    unsigned long diag_opt;
    int opt_res;
    unsigned long reg, val, id;
    uchar buffer;
    static ulong lcd = 0;

    if( lcd_get_ndev() == 0 ) {
        printf("\nNo Video Controllers found.\n");
        return result;
    }

    while (lcd_flag) {
        print_lcd_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case LCD_MENU_EXIT:
                lcd_flag = 0;
                break;

            case LCD_MENU_SELECT:
                printf("\nCurrent test LCD: %ld", lcd);
                printf("\nEnter LCD to test [valid 0-%d]", lcd_get_ndev() - 1);
                nchars = readline(": ");
                if (nchars > 0) {
                    id = simple_strtoul(console_buffer, NULL, 10);
                    if (check_lcd(id) == 0) {
                        lcd = id;
                    }
                }
                break;

            case LCD_MENU_READ_ALL:
                for (reg = AD9888_CHIP_REV; reg <= AD9888_TEST_REG4; reg++) {
                    ad9888_print(reg, ad9888_read(lcd, reg));
                }
                break;

            case LCD_MENU_READ:
                nchars = print_prompt("\nEnter register addr: 0x", &reg, 16);
                if (nchars > 0 && check_regaddr(reg) == 0) {
                    ad9888_print(reg, ad9888_read(lcd, reg));
                }
                break;

            case LCD_MENU_WRITE:
                nchars = print_prompt("\nEnter register addr: 0x", &reg, 16);
                if (nchars > 0 && check_regaddr(reg) == 0) {
                    nchars = print_prompt("Enter value to write: 0x",
                                          &val, 16);
                    buffer = (u8)(val & 0xff);
                    ad9888_write(lcd, reg, buffer);
                }
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_LCD) */
