/******************************************************************************
 *  KX2.0 Main Menu for all Test and Utility Programs
 *
 *  FILE: main_menu.c
 *
 ******************************************************************************
 *
 *                        COPYRIGHT (c) 2003
 *
 *                       Raritan Computer, Inc.
 *                        400 Cottontail Lane
 *                        Somerset, NJ 08837
 *                           732.764.8886
 *
 *                      All rights reserved.
 * Copying, compilation, modification, distribution or any other use 
 *   whatsoever of this material is strictly prohibited except in
 * accordance with a Software License Agreement with Raritan Computer, Inc.
 *****************************************************************************/

#include <common.h>
#include <command.h>
#include <board_type.h>
#include <main_menu.h>
#include <setenv_menu.h>
#include <diag_menu.h>
#include <util_menu.h>
#include <update_menu.h>
#include <util.h>
#include <mfg_test.h>


/* for do_reset() prototype */
extern int do_reset (cmd_tbl_t *cmdtp, int flag, int argc, char *argv[]);


void print_menu( int board_type, int major, int minor, int patch )
{
    static char boardname[20];
    static char config = 0;
    int i = 1;

    if( !config ) {
        memset(boardname, 0, 20);
        switch( board_type ) {
            case RARITAN_BOARD_KX101:
                strncpy(boardname, "KX101", 5);
                break;
            case RARITAN_BOARD_KXGEN2:
                strncpy(boardname, "KX2.0", 5);
                break;
            default:
                strncpy(boardname, "HW", 2);
                break;
        }
        config = 1;
    }

    printf("\n Raritan %s Diagnostics Version %d.%d.%d:",
           boardname, major, minor, patch);
    printf("\n============================================");
    printf("\n\t b: Boot Linux kernel");
    printf("\n\t %d: Setup Environment", i++);
    printf("\n\t %d: Diagnostics", i++);
    printf("\n\t %d: Utilities", i++);
    printf("\n\t %d: Update Images", i++);
    printf("\n\t %d: FINAL Setup for Customer/Production Use", i++);
    printf("\n\t %d: Reset Board", i++);
    printf("\n\t %d: Run Manufacturing Test", i++);
    printf("\n\n");

    return;
}

int main_menu( int board_type, char *opt )
{
    int diag_opt;
    int result = 1;
    cmd_tbl_t *cmdtp;
    char tmp[10];
    char *argv[1];

    if (opt[0] == 'U') {
        printf("\nReverting back to U-BOOT commands\n\n");
        return 0;
    }
    else if (opt[0] == 'b') {
        /* boot the linux kernel */
        argv[0] = tmp;
        strcpy(argv[0], "bootd");
        if ((cmdtp = find_cmd(argv[0])) != NULL) {
            if ((cmdtp->cmd) (cmdtp, 0, 1, argv) != 0) {
                printf ("Failed to Boot\n");
            }
        }
        else {
            printf ("Unknown command 'bootd' - try 'help'\n");
        }

        return result;
    }

    diag_opt = simple_strtoul(opt, NULL, 10);

    switch( diag_opt )
    {
        case SETUP_ENV:
            result = setenv_menu();
            break;

        case DIAGNOSTICS:
            result = diag_menu();
            break;

        case UTILITIES:
            result = util_menu();
            break;

        case IMAGE_UPDATE:
            result = update_menu(board_type);
            break;

        case CUSTOMER_SETENV:
            setenv_for_customer_use();
            break;

        case BOARD_RESET:
            do_reset(NULL, 0, 0, NULL);
            break;

        case MFG_TEST:
            mfg_test();
            break;

        case MFG_TEST_OPT:
            mfg_test_options();
            break;

        default:
            print_invalid();
            break;
    }

    return result;
}
