/*****************************************************************************
 *  Philips PCA9543A 2-channel I2C switch interface functions
 *
 *  FILE: pca9543a.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <command.h>
#include <i2c.h>
#include <pca9543a.h>


static uchar pca9543a_present = 0;

/*-----------------------------------------------------------------------------
 * PCA9543A Initialization Routine
 *---------------------------------------------------------------------------*/
void pca9543a_init( void )
{
    pca9543a_present = 0;

    /* probe for the presence of the device */
    if (i2c_probe(PCA9543A_I2C_ADDR) != 0) {
        printf("\nWARNING: No I2C Switch found.\n");
        return;
    }

    pca9543a_present = 1;
}

/*-----------------------------------------------------------------------------
 * PCA9543A Register Read Routine
 *
 * This device only requires the slave address (device i2c address) to 
 * get the data from the I/O port. No register byte address is present.
 *---------------------------------------------------------------------------*/
uchar pca9543a_read( void )
{
    uchar buf;

    if( pca9543a_present ) {
        i2c_read(PCA9543A_I2C_ADDR, 0, 0, &buf, 1);
    }
    else {
        return 0xFF;
    }

    return( buf );
}

/*-----------------------------------------------------------------------------
 * PCA9543A Register Write Routine
 *
 * This device only requires the slave address (device i2c address) to 
 * get the data from the I/O port. No register byte address is present.
 *---------------------------------------------------------------------------*/
void pca9543a_write( uchar val )
{
    if( pca9543a_present ) {
        i2c_write(PCA9543A_I2C_ADDR, 0, 0, &val, 1);
    }

    return;
}

/*-----------------------------------------------------------------------------
 * PCA9543A Select Channel Routine
 *---------------------------------------------------------------------------*/
int pca9543a_select_channel( char chan )
{
    switch( chan ) {
        case 0:
        case 1:
            break;
        default:
            return -1;
    }

    pca9543a_write(1 << chan);

    return 0;
}
