/*****************************************************************************
 *  MII PHY LXT972 Utilities Menu
 *
 *  FILE: phy_lxt972_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_PHY)

#include <mii_phy_10_100.h>
#include <phy_lxt972_menu.h>
#include <lxt972.h>
#include <util.h>


static void print_ledcfg_menu( void )
{
    int i = 1;

    printf("\nMII PHY LED CONFIGURATION:");
    print_exit();
    printf("\n\t %d: Change LED Id", i++);
    printf("\n\t %d: Display Speed (continuous)", i++);
    printf("\n\t %d: Display Transmit Status (stretched)", i++);
    printf("\n\t %d: Display Receive Status (stretched)", i++);
    printf("\n\t %d: Display Collision Status (stretched)", i++);
    printf("\n\t %d: Display Link Status (continuous)", i++);
    printf("\n\t %d: Display Duplex Status (continuous)", i++);
    printf("\n\t %d: Display Receive or Transmit Activity (stretched)", i++);
    printf("\n\t %d: Test mode - turn LED on", i++);
    printf("\n\t%d: Test mode - turn LED off", i++);
    printf("\n\t%d: Test mode - blink LED fast", i++);
    printf("\n\t%d: Test mode - blink LED slow", i++);
    printf("\n\t%d: Display Link and Receive Status (stretched)", i++);
    printf("\n\t%d: Display Link and Activity Status (stretched)", i++);
    printf("\n\t%d: Display Duplex and Collision Status (stretched)", i++);
    printf("\n\t%d: Stretch LED events to 30 ms ", i++);
    printf("\n\t%d: Stretch LED events to 60 ms ", i++);
    printf("\n\t%d: Stretch LED events to 100 ms ", i++);
    printf("\n\t%d: Disable Pulse Stretching of all LEDs ", i++);
    printf("\n\t%d: Enable Pulse Stretching of all LEDs ", i++);
    printf("\n\n");

    return;
}

int phy_ledcfg_menu( int type )
{
    char phy_flag = 1;
    int result = 1;
    unsigned long diag_opt;
    int opt_res;
    int nchars;
    ulong id;
    ushort led = PHY_LED1;

    if( type != PHY_ID_LXT972 ) {
        return -1;
    }

    while (phy_flag) {
        print_ledcfg_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case PHY_LXT972_LEDCFG_EXIT:
                phy_flag = 0;
                break;

            case PHY_LXT972_LEDCFG_SELECT_LED:
                nchars = print_prompt("\nEnter LED id [1-3]: ", &id, 10);
                if (nchars > 0) {
                    switch(id) {
                        case 1:
                            led = PHY_LED1;
                            break;
                        case 2:
                            led = PHY_LED2;
                            break;
                        case 3:
                            led = PHY_LED3;
                            break;
                        default:
                            printf("Error: Invalid LED id!\n\n");
                    }
                }
                break;

            case PHY_LXT972_LEDCFG_DISP_SPEED:
                mii_phy_config_led(led, LED_DISP_SPEED, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_TX:
                mii_phy_config_led(led, LED_DISP_TX, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_RX:
                mii_phy_config_led(led, LED_DISP_RX, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_CLSN:
                mii_phy_config_led(led, LED_DISP_COLLISION, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_LINK:
                mii_phy_config_led(led, LED_DISP_LINK, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_DUPLEX:
                mii_phy_config_led(led, LED_DISP_DUPLEX, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_TX_RX:
                mii_phy_config_led(led, LED_DISP_TX_RX, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_ON:
                mii_phy_config_led(led, LED_DISP_TEST_ON, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_OFF:
                mii_phy_config_led(led, LED_DISP_TEST_OFF, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_BLINK_FAST:
                mii_phy_config_led(led, LED_DISP_TEST_BLINK_FAST, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_BLINK_SLOW:
                mii_phy_config_led(led, LED_DISP_TEST_BLINK_SLOW, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_LINK_RX:
                mii_phy_config_led(led, LED_DISP_LINK_RX, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_LINK_ACT:
                mii_phy_config_led(led, LED_DISP_LINK_ACTIVITY, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_DISP_DUPLEX_CLSN:
                mii_phy_config_led(led, LED_DISP_DUPLEX_CLSN, PHY_LED_OPTION1);
                break;

            case PHY_LXT972_LEDCFG_STRETCH_30:
                mii_phy_config_led(led, LED_STRETCH_30MS, PHY_LED_OPTION2);
                break;

            case PHY_LXT972_LEDCFG_STRETCH_60:
                mii_phy_config_led(led, LED_STRETCH_60MS, PHY_LED_OPTION2);
                break;

            case PHY_LXT972_LEDCFG_STRETCH_100:
                mii_phy_config_led(led, LED_STRETCH_100MS, PHY_LED_OPTION2);
                break;

            case PHY_LXT972_LEDCFG_DISABLE_PS:
                mii_phy_config_led(led, LED_STRETCH_DISABLE, PHY_LED_OPTION3);
                break;

            case PHY_LXT972_LEDCFG_ENABLE_PS:
                mii_phy_config_led(led, LED_STRETCH_ENABLE, PHY_LED_OPTION3);
                break;

            default:
                print_invalid();
                break;
       }
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_PHY) */
