/*****************************************************************************
 *  MII PHY Utilities Menu
 *
 *  FILE: phy_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

#if defined(CFG_RARITAN_UTIL_PHY)

#include <mii_phy.h>
#include <miiphy.h>
#include <mii_phy_10_100.h>
#include <phy_menu.h>
#include <util.h>


static void print_phy_menu( void );
static void print_config_phy_menu( void );
static int  config_phy( void );

static void print_phy_menu( void )
{
    int i = 1;

    printf("\nMII PHY Utilities:");
    print_exit();
    printf("\n\t %d: Reset PHY", i++);
    printf("\n\t %d: Read Register", i++);
    printf("\n\t %d: Write Register", i++);
    printf("\n\t %d: Read All Registers", i++);
    printf("\n\t %d: Get Status", i++);
    printf("\n\t %d: Get Configuration", i++);
    printf("\n\t %d: Change Configuration", i++);
    printf("\n\t %d: Configure LED", i++);
    printf("\n\n");

    return;
}

int phy_menu( void )
{
    char phy_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long reg, val;
    int num_chars;
    unsigned long diag_opt;
    int opt_res;
    int auton, linkopt;

    mii_discover_phy();

    /* found_phy is defined in mii_phy8260.h */
    if (found_phy == 0) {
        printf("No PHY is present in the board!\n");
        phy_flag = 0;
    }

    while (phy_flag && result != 0) {
        print_phy_menu();

        opt_res = menu_get_user_input(&diag_opt);
        if( opt_res > 0 ) {
            return 0;
        }
        else if( opt_res < 0 ) {
            continue;
        }

        switch( diag_opt ) {
            case PHY_MENU_EXIT:
                phy_flag = 0;
                break;

            case PHY_MENU_SW_RESET:
                mii_sw_reset();
                break;

            case PHY_MENU_READ_REG:
                if (mii_check_phy() == 0) {
                    num_chars = print_prompt("\nEnter register address: ",
                                             &reg, 10);
                    if (num_chars > 0) {
                        printf("PHY ADDR 0x%02x = 0x%04x\n", (ushort)reg,
                               mii_phy_read(reg));
                    }
                }
                break;

            case PHY_MENU_WRITE_REG:
                if (mii_check_phy() == 0) {
                    num_chars = print_prompt("\nEnter register address: ",
                                             &reg, 10);
                    if (num_chars > 0) {
                        num_chars = print_prompt("Enter value to write  : 0x",
                                                 &val, 16);
                        if (num_chars > 0) {
                            mii_phy_write(reg, val);
                        }
                    }
                }
                break;

            case PHY_MENU_READ_ALL_REG:
                mii_read_all_regs();
                break;

            case PHY_MENU_GET_STATUS:
                mii_get_status();
                break;

            case PHY_MENU_GET_CONFIG:
                mii_phy_get_configuration(&auton, &linkopt);
                printf("\n");
                mii_phy_print_configuration(auton, linkopt);
                break;

            case PHY_MENU_CHANGE_CONFIG:
                result = config_phy();
                break;

            case PHY_MENU_CONFIG_LED:
                /* figure out PHY type */
                val = mii_get_phy();
                result = phy_ledcfg_menu(val);
                break;

            default:
                print_invalid();
                break;
        }
    }

    return result;
}


static void print_config_phy_menu( void )
{
    printf("\nMII PHY CONFIGURATION:");
    print_exit();
    printf("\n\t 1: Auto-negotiation, 10/100 Mbs, Full-or-Half-duplex");
    printf("\n\t 2: Auto-negotiation, 10/100 Mbs, Half-duplex only");
    printf("\n\t 3: Auto-negotiation, 100 Mbs, Full-duplex");
    printf("\n\t 4: Auto-negotiation, 100 Mbs, Half-duplex");
    printf("\n\t 5: Auto-negotiation, 10 Mbs, Full-duplex");
    printf("\n\t 6: Auto-negotiation, 10 Mbs, Half-duplex");
    printf("\n\t 7: 100 Mbs, Full-duplex");
    printf("\n\t 8: 100 Mbs, Half-duplex");
    printf("\n\t 9: 10 Mbs, Full-duplex");
    printf("\n\t10: 10 Mbs, Half-duplex");
    printf("\n\n");

    return;
}

static int config_phy( void )
{
    int num_chars;
    unsigned long option;
    int result = 1;

    print_config_phy_menu();
    num_chars = readline("Please choose: ");

    option = simple_strtoul(console_buffer, NULL, 10);

    switch( option ) {
       case PHY_CFG_EXIT:
          break;

       case PHY_CFG_AUTONEG_LINK_ALL:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_ALL);
          break;

       case PHY_CFG_AUTONEG_LINK_10_100HD:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_10_100HD);
          break;

       case PHY_CFG_AUTONEG_LINK_100FD:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_100FD);
          break;

       case PHY_CFG_AUTONEG_LINK_100HD:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_100HD);
          break;

       case PHY_CFG_AUTONEG_LINK_10FD:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_10FD);
          break;

       case PHY_CFG_AUTONEG_LINK_10HD:
          mii_phy_set_configuration(AUTONEG_ENABLE, LINK_10HD);
          break;

       case PHY_CFG_LINK_100FD:
          mii_phy_set_configuration(AUTONEG_DISABLE, LINK_100FD);
          break;

       case PHY_CFG_LINK_100HD:
          mii_phy_set_configuration(AUTONEG_DISABLE, LINK_100HD);
          break;

       case PHY_CFG_LINK_10FD:
          mii_phy_set_configuration(AUTONEG_DISABLE, LINK_10FD);
          break;

       case PHY_CFG_LINK_10HD:
          mii_phy_set_configuration(AUTONEG_DISABLE, LINK_10HD);
          break;

       default:
          print_invalid();
          break;
    }

    return result;
}

#endif /* (CFG_RARITAN_UTIL_PHY) */
