/*****************************************************************************
 *  Raritan Console Startup
 *
 *  FILE: raritan_console.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include "raritan_console.h"

#if defined( CONFIG_KXGEN2 )
#include "kxgen2_version.h"
#endif


static void disable_console( void )
{
    DECLARE_GLOBAL_DATA_PTR;
    gd->have_console = 0;
    gd->pp.serial_debug = 0;
}

static int enable_console( void )
{
    /* 
     * 0 - no console
     * 1 - console enabled, password enabled
     * 2 - console enabled, password disabled
     */
    int enable = 0;
    int delay = 3;
    int key;
    char *str;
    DECLARE_GLOBAL_DATA_PTR;

    if(gd->env_valid) {
        /* look for console */
	str = getenv("serial_debug");
        if(str && (strcmp(str, "1") == 0)) {
            /* console should always be on for now */
            return 2;
        }
    }
    else {
        /*
         * When first time booting up or environment has been erased,
         * always enable the console.
         */
        return 2;
    }

    while (delay > 0) {
        int i;

        --delay;
        /* delay 100 * 10ms */
        for (i=0; !enable && i<100; ++i) {
            if (tstc()) {	/* we got a key press	*/
                key = getc();

                if(key == DELETE_KEY) {
                    enable = 1;	/* enable console messages */
                    delay = 0;	/* no more delay	*/
                    break;
                }
            }
            udelay (10000);
        }
    }

    return enable;
}

static __inline__ int verify_login( void )
{
    int num_chars = 0;
    char code_buffer[ACCESS_CODE_SIZE];

    printf("\nPlease Input Raritan Access Code: ");

    for (;;) {
        code_buffer[num_chars] = getc();

        /*
         * Special character handling
         */
        if (code_buffer[num_chars] == '\n' || code_buffer[num_chars] == '\r') {
            break;
        }
        ++num_chars;
        if (num_chars >= ACCESS_CODE_SIZE) {
            break;
        }
    }

    if ((num_chars <= 0) || (num_chars > ACCESS_CODE_SIZE)) {
        return 0;
    }
    else {
        return( verify_password(num_chars, code_buffer) );
    }
}

int raritan_console( void )
{
    int conlvl;
    int major, minor, patch;
    DECLARE_GLOBAL_DATA_PTR;

    if((conlvl = enable_console())) {
        int try = 0, access_ok = 0;

        /* enable the console */
        console_init_f();
        gd->pp.serial_debug = 1;

        /* simple verification of user if not bypassed */
        if(conlvl == 1) {
            printf("\n");
            do {
                access_ok = verify_login();
                if (!access_ok) {
                    printf("Incorrect access code");
                }
                ++try;
            } while (!access_ok && try < LOGIN_RETRY);

            if (!access_ok) {
                printf("\nContinuing booting in silent mode.\n");
                disable_console();
                printf("Console disabled.\n");
                return 0;
            }
        }

#if defined( CONFIG_KXGEN2 )
        major = KXGEN2_MAJOR_NUM;
        minor = KXGEN2_MINOR_NUM;
        patch = KXGEN2_PATCH_NUM;
#else
        major = 0;
        minor = 0;
        patch = 0;
#endif

        printf("\n\n/===================================================/\n");
        printf("\n\tRaritan Monitor Version %d.%d.%d\n", major, minor, patch);
        printf("\tCopyright 2006 Raritan Computer, Inc.\n");
        printf("\n/===================================================/\n\n");

    }
    else {
        /* enable the console */
        console_init_f();
        gd->pp.serial_debug = 1;

        printf("\nSystem is booting please wait...\n");

        disable_console();
    }

    return 0;
}
