/*****************************************************************************
 *  Utility Menu
 *
 *  FILE: util_menu.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>
#include <util.h>
#include <util_menu.h>
#include <memory_menu.h>
#include <flash_menu.h>

#if defined(CFG_RARITAN_UTIL_I2C)
#include <i2c_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_RTC)
#include <rtc_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_PHY)
#include <phy_menu.h>
#endif


#if defined(CFG_RARITAN_UTIL_EEPROM)
#include <eeprom_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_LCD)
#include <lcd_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_LED)
#include <led_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_RS485)
#include <rs485_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_SPEAKER)
#include <speaker_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_POWER)
#include <power_menu.h>
#endif

#if defined(CFG_RARITAN_UTIL_RESET_BUTTON)
#include <reset_button_menu.h>
#endif


static void print_util_menu( void )
{
    int i = 1;

    printf("\nUtilities:");
    print_exit();
    printf("\n\t %d: Flash Utilities", i++);
    printf("\n\t %d: Memory Utilities", i++);
#if defined(CFG_RARITAN_UTIL_I2C)
    printf("\n\t %d: I2C Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_RTC)
    printf("\n\t %d: RTC Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_PHY)
    printf("\n\t %d: Ethernet PHY Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_EEPROM)
    printf("\n\t %d: Ethernet EEPROM Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_LCD)
    printf("\n\t %d: LCD Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_LED)
    printf("\n\t %d: LED Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_RS485)
    printf("\n\t %d: RS485 Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_SPEAKER)
    printf("\n\t %d: Speaker Utilities", i++);
#endif
#if defined(CFG_RARITAN_UTIL_POWER)
    printf("\n\t");
    if( i >= 10 ) {
        printf("%d", i++);
    }
    else {
        printf(" %d", i++);
    }
    printf(": Power Supply Utilities");
#endif
#if defined(CFG_RARITAN_UTIL_RESET_BUTTON)
    printf("\n\t");
    if( i >= 10 ) {
        printf("%d", i++);
    }
    else {
        printf(" %d", i++);
    }
    printf(": Reset Button Utilities");
#endif
    printf("\n\n");

    return;
}

int util_menu( void )
{
    char util_flag = 1;
    int result = 1; /* result is used for reverting back to U-boot cmds */
    unsigned long diag_opt;
    int opt_res;

    while (util_flag) {
       print_util_menu();

       opt_res = menu_get_user_input(&diag_opt);
       if( opt_res > 0 ) {
           return 0;
       }
       else if( opt_res < 0 ) {
           continue;
       }

       switch( diag_opt ) {
           case UTIL_MENU_EXIT:
              util_flag = 0;
              break;

           case FLASH_UTILITIES:
               result = flash_menu();
               break;

           case MEMORY_UTILITIES:
               result = memory_util_menu();
               break;

#if defined(CFG_RARITAN_UTIL_I2C)
           case I2C_UTILITIES:
               result = i2c_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_RTC)
           case RTC_UTILITIES:
               result = rtc_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_PHY)
           case PHY_UTILITIES:
               result = phy_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_EEPROM)
           case EEPROM_UTILITIES:
               result = eeprom_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_LCD)
           case LCD_UTILITIES:
               result = lcd_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_LED)
           case LED_UTILITIES:
               result = led_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_RS485)
           case RS485_UTILITIES:
               result = rs485_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_SPEAKER)
           case SPEAKER_UTILITIES:
               result = speaker_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_POWER)
           case POWER_UTILITIES:
               result = power_menu();
               break;
#endif

#if defined(CFG_RARITAN_UTIL_RESET_BUTTON)
           case RESET_BUTTON_UTILITIES:
               result = reset_button_menu();
               break;
#endif

           default:
               print_invalid();
               break;
       }

       if( result == 0 ) {
           util_flag = 0;
       }
    }

    return result;
}
