/*****************************************************************************
 *  Speaker/Buzzer routines
 *
 *  FILE: speaker.c
 *
 ******************************************************************************
 *
 * This source code is owned by Raritan Computer, Inc. and is confidential 
 * proprietary information distributed solely pursuant to a confidentiality 
 * agreement or other confidentiality obligation.  It is intended for
 * informational purposes only and is distributed "as is" with no support
 * and no warranty of any kind.
 *
 * Copyright @ 2004-2005 Raritan Computer, Inc. All rights reserved.
 * Reproduction of any element without the prior written consent of
 * Raritan Computer, Inc. is expressly forbidden.
 *
 *****************************************************************************/

#include <common.h>

/* 
 * The LED GPIO is configured in cpu/ppc4xx/cpu_init.c
 */

#define LED_GPIO3    0x10000000

void speaker_on( unsigned short freq )
{
    u32 gpio0_or;

    gpio0_or = in32(GPIO0_OR);
    gpio0_or |= LED_GPIO3;
    out32(GPIO0_OR, gpio0_or);

    return;
}

void speaker_off( void )
{
    u32 gpio0_or;

    gpio0_or = in32(GPIO0_OR);
    gpio0_or &= ~LED_GPIO3;
    out32(GPIO0_OR, gpio0_or);

    return;
}
