/*
 * Copyright (c) 2004 Peppercon AG
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms are freely
 * permitted provided that the above copyright notice and this
 * paragraph and the following disclaimer are duplicated in all
 * such forms.
 *
 * This software is provided "AS IS" and without any express or
 * implied warranties, including, without limitation, the implied
 * warranties of merchantability and fitness for a particular
 * purpose.
 */

#include <common.h>
#include <command.h>


#ifdef CONFIG_PEPPERCON

static int do_defaults(cmd_tbl_t *cmdtp, int flag, int argc, char *argv[])
{
	DECLARE_GLOBAL_DATA_PTR;
	printf("Please wait...\n");
	gd->pp.def_jumper_set = PP_DEFAULTS_COMMAND;
	gd->pp.serial_debug = 0;
	return (run_command(getenv("bootcmd"), flag, 0) < 0 ? 1 : 0);
}

U_BOOT_CMD(
	defaults, 1,              1,      do_defaults,
        "defaults- set the device settings to their factory defaults\n",
	""
);

#endif	/* CONFIG_PEPPERCON */
