#include <common.h>
#include <command.h>

/*
 * Macros to generate global absolutes.
 */
#define GEN_SYMNAME(str) #str
#define GEN_VALUE(str) #str
#define GEN_ABS(name, value) \
		asm (".globl " GEN_SYMNAME(name)); \
		asm (GEN_SYMNAME(name) " = " GEN_VALUE(value))

uint32_t __attribute__ ((section(".crcsum"))) crcsum = 0;

#ifdef CONFIG_KIRA
GEN_ABS(crc_offset, CFG_CRC_OFFSET);
#else
GEN_ABS(crc_offset, CFG_CRC_ADDR);
#endif

int pp_debug_init (void)
{
    DECLARE_GLOBAL_DATA_PTR;
    char tmp[11];
    int serial_debug;
    int i;

    /*
     * Check if we should output on serial port if a debug cable is found
     * also decide if to start in restricted user or in devel mode.
     */
    i = getenv_r("serial_debug", tmp, sizeof(tmp));
    gd->pp.devel_mode =
	serial_debug = (i > 0) ? (int)simple_strtoul(tmp, NULL, 10) : 0;

    gd->pp.serial_debug = serial_debug;

    /*
     * initialize power_cim to be not there
     */
    gd->pp.power_cim = 0;

    return (0);
}

int pp_init(void) {
    command_enable_user("erla");
    command_enable_user("reset");
    command_enable_user("config");
    command_enable_user("defaults");
    command_enable_user("help");

    return 0;
}

int pp_check_crc(void)
{
#if defined(PP_BOARD_KIRA) && !defined(PP_FEAT_SPI_BOOT)
    DECLARE_GLOBAL_DATA_PTR;
    u_char *data = (u_char*) CFG_FLASH_BASE;
    u_long len = CFG_CRC_OFFSET;
    u_long crc = crc32(0, data, len);

    if (crc != crcsum) {
	gd->pp.serial_debug = 1;
	printf("CRC mismatch (expected %08x, got %08x)\n", crcsum, crc);
	/* FIXME: CRC error non-fatal for now, as there are problems when flashing in u-boot */
	return 0;
	//return -1;
    }

    printf("CRC check passed\n");
#endif
    /* for PPC we don't check at the moment as its too slow */
    return 0;
}
