/*
 * (C) Copyright 2000, 2001
 * Wolfgang Denk, DENX Software Engineering, wd@denx.de.
 *
 * Derived work: (C) Copyright 2002-2005 Peppercon AG
 *
 * See file CREDITS for list of people who contributed to this
 * project.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	 See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

/*
 * board/config.h - configuration options, board specific
 */

#ifndef __CONFIG_H
#define __CONFIG_H

/*
 * Include our board specific stuff.
 */
#include <peppercon.h>

/*
 * High Level Configuration Options
 * (easy to change)
 */

#if PP_(CPU_TYPE, PP_HWID) == PP_CPU_405GP
# define CONFIG_405GP		1
#elif PP_(CPU_TYPE, PP_HWID) == PP_CPU_405EP
# define CONFIG_405EP		1
#else
# error Unexpected processor type!
#endif
#define CONFIG_4xx		1	/* ...member of PPC4xx family */
#define CONFIG_BOARD_PRE_INIT	1	/* Call board_pre_init */
#define CONFIG_SYS_CLK_FREQ	PP_(SYS_CLK_FREQ, PP_HWID) /* external frequency to PLL */

#if PP_(CONSOLE, PP_HWID) == PP_SERIAL_1
# define CONFIG_UART1_CONSOLE 1
#endif

/*
 * If CFG_EXT_SERIAL_CLOCK, then the UART divisor is 1.
 * If CFG_405_UART_ERRATA_59, then UART divisor is 31.
 * Otherwise, UART divisor is determined by CPU Clock and CFG_BASE_BAUD value.
 * The Linux BASE_BAUD define should match this configuration.
 *    baseBaud = cpuClock/(uartDivisor*16)
 * If CFG_405_UART_ERRATA_59 and 200MHz CPU clock,
 * set Linux BASE_BAUD to 403200.
 */
#undef  CFG_EXT_SERIAL_CLOCK	/* external serial clock */
#undef  CFG_405_UART_ERRATA_59	/* 405GP/CR Rev. D silicon */
#define CFG_BASE_BAUD		691200
/* The following table includes the supported baudrates */
#define CFG_BAUDRATE_TABLE  \
	{300, 600, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200, 230400}

/*
 * Size (bytes) of interrupt driven serial port buffer.
 * Set to 0 to use polling instead of interrupts.
 * Setting to 0 will also disable RTS/CTS handshaking.
 */
#if 0
# define CONFIG_SERIAL_SOFTWARE_FIFO 4000
#else
# undef  CONFIG_SERIAL_SOFTWARE_FIFO
#endif




#  if PP_(FLASH_SIZE,PP_HWID) == (4*1024*1024)
#    define _MEM_CONFIG_BOOTCOMMAND	"bootm ffc00000 ffcc0000"
#  elif PP_(FLASH_SIZE,PP_HWID) == (8*1024*1024)
#    define _MEM_CONFIG_BOOTCOMMAND	"bootm ff800000 ff8e0000"
#  elif PP_(FLASH_SIZE,PP_HWID) == (16*1024*1024)
#    define _MEM_CONFIG_BOOTCOMMAND	"bootm ff000000 ff0e0000"
#  else
#    error Unexpected flash size!
#  endif

#define _TFTPBOOT_CONFIG_BOOTCOMMAND "tftpboot"

#define _JFFS_CONFIG_BOOTCOMMAND "fsload uImage ; bootm"

#define _BIGPHYSAREA PP_BIGPHYSAREA_OPT(PP_HWID)

#if PP_(CONFIG_BOOTDELAY, PP_HWID) > 0
#define _HWID_CONFIG_BOOTDELAY PP_(CONFIG_BOOTDELAY, PP_HWID)
#else
#define _HWID_CONFIG_BOOTDELAY 3
#endif

#include "PP_COMMON.h"


#define CONFIG_MII		1	/* MII PHY management */
#ifdef PRODUCT_ICPMMD
# define CONFIG_PREF_PHY_ADDR	0	/* Prefered PHY address (for >1 PHY) */
#else
# define CONFIG_PREF_PHY_ADDR	1	/* Prefered PHY address (for >1 PHY) */
#endif

/* this must be included AFTER the definition of CONFIG_COMMANDS (if any) */
#include <cmd_confdefs.h>

#undef CONFIG_WATCHDOG			/* watchdog disabled */

/*
 * Miscellaneous configurable options
 */

#define CFG_MEMTEST_START	0x0400000	/* memtest works on */
#define CFG_MEMTEST_END		0x0C00000	/* 4 ... 12 MB in DRAM */
#define CFG_LOAD_ADDR		0x200000	/* default load address */
#define CFG_EXTBDINFO		1	/* To use extended board_into (bd_t) */
#define	CFG_HZ			1000	/* decrementer freq: 1 ms ticks	*/
#define CONFIG_HARD_I2C		1	/* I2C with hardware support	*/
#undef  CONFIG_SOFT_I2C			/* I2C bit-banged		*/
#define CFG_I2C_SPEED		400000	/* I2C speed and slave address	*/
#define CFG_I2C_SLAVE		0

/*-----------------------------------------------------------------------
 * PCI stuff
 *-----------------------------------------------------------------------
 */
#define PCI_HOST_ADAPTER	0	/* configure as pci adapter     */
#define PCI_HOST_FORCE		1	/* configure as pci host        */
#define PCI_HOST_AUTO		2       /* detected via arbiter enable  */

#define CONFIG_PCI			/* include pci support	        */
#define CONFIG_PCI_HOST	PCI_HOST_FORCE  /* select pci host function     */
#undef CONFIG_PCI_PNP			/* no pci plug-and-play         */
					/* resource configuration       */

#define CFG_PCI_VENDORID 0x1743		/* PCI Vendor ID: Peppercon AG  */
#define CFG_PCI_DEVICEID 0x0405		/* PCI Device ID: 405           */
#define CFG_PCI_SUBSYS_VENDORID 0x1743	/* PCI Vendor ID: Peppercon AG  */
#define CFG_PCI_SUBSYS_DEVICEID 0x0405	/* PCI Device ID: 405           */

#define CFG_PCI_CLASSCODE 0x0600	/* PCI Class Code: Bridge	*/

/* --- PCI resources ---- */

/* PLB -> PCI Region 0 */
#define CFG_PCI_PMM0LA    0x80000000    /* map PCI MEM			*/
#define CFG_PCI_PMM0PCILA 0x80000000
#define CFG_PCI_PMM0PCIHA 0x00000000
#define CFG_PCI_PMM0MA    0xC0000001    /* 1GB; no prefetching; enable	*/

/* PLB -> PCI Region 1 */
#define CFG_PCI_PMM1LA    0x00000000	/* disabled			*/
#define CFG_PCI_PMM1PCILA 0x00000000
#define CFG_PCI_PMM1PCIHA 0x00000000
#define CFG_PCI_PMM1MA    0x00000000

/* PLB -> PCI Region 2 */
#define CFG_PCI_PMM2LA     0x00000000	/* disabled			*/
#define CFG_PCI_PMM2PCILA  0x00000000
#define CFG_PCI_PMM2PCIHA  0x00000000
#define CFG_PCI_PMM2MA     0x00000000

/* PCI -> PLB Region 1 */
#define CFG_PCI_PTM1LA     0x00000000	/* point to PPC memory          */
#define CFG_PCI_PTM1MS	   0xFC000001	/* 64 MB			*/
#define CFG_PCI_PTM1PCI    0x00000000   /* Host: use this pci address   */
	
/* PCI -> PLB Region 2 */
#define CFG_PCI_PTM2LA     0x00000000   /* disabled			*/
#define CFG_PCI_PTM2MS     0x00000000
#define CFG_PCI_PTM2PCI    0x00000000

/* --------------------------------------------------------------------------
 * GPIO stuff (only for PPC405EP)
 */
#ifdef CONFIG_405EP
# define CFG_GPIO0_OSRH  PP_CALC_GPIO0_OSRH(PP_HWID)
# define CFG_GPIO0_OSRL  PP_CALC_GPIO0_OSRL(PP_HWID)
# define CFG_GPIO0_ISR1H 0x55555555
# define CFG_GPIO0_ISR1L 0x55555555
# define CFG_GPIO0_TSRH  0x00000000
# define CFG_GPIO0_TSRL  0x00000000
# define CFG_GPIO0_TCR   PP_CALC_GPIO0_TCR(PP_HWID)
#endif

/* --------------------------------------------------------------------------
 * External Bus Controller
 */

/* The Peripheral Bank Access Parameters */
#define CFG_EBC_PB0AP	PP_CALC_EBC0_BnAP(PP_HWID, 00)
#define CFG_EBC_PB1AP	PP_CALC_EBC0_BnAP(PP_HWID, 01)
#define CFG_EBC_PB2AP	PP_CALC_EBC0_BnAP(PP_HWID, 02)
#define CFG_EBC_PB3AP	PP_CALC_EBC0_BnAP(PP_HWID, 03)
#define CFG_EBC_PB4AP	PP_CALC_EBC0_BnAP(PP_HWID, 04)
#ifndef CONFIG_405EP /* PPC405EP has only 5 chip selects */
# define CFG_EBC_PB5AP	PP_CALC_EBC0_BnAP(PP_HWID, 05)
# define CFG_EBC_PB6AP	PP_CALC_EBC0_BnAP(PP_HWID, 06)
# define CFG_EBC_PB7AP	PP_CALC_EBC0_BnAP(PP_HWID, 07)
#endif

/* The Peripheral Bank Configuration Registers */
#define CFG_EBC_PB0CR	PP_CALC_EBC0_BnCR(PP_HWID, 00)
#define CFG_EBC_PB1CR	PP_CALC_EBC0_BnCR(PP_HWID, 01)
#define CFG_EBC_PB2CR	PP_CALC_EBC0_BnCR(PP_HWID, 02)
#define CFG_EBC_PB3CR	PP_CALC_EBC0_BnCR(PP_HWID, 03)
#define CFG_EBC_PB4CR	PP_CALC_EBC0_BnCR(PP_HWID, 04)
#ifndef CONFIG_405EP /* PPC405EP has only 5 chip selects */
# define CFG_EBC_PB5CR	PP_CALC_EBC0_BnCR(PP_HWID, 05)
# define CFG_EBC_PB6CR	PP_CALC_EBC0_BnCR(PP_HWID, 06)
# define CFG_EBC_PB7CR	PP_CALC_EBC0_BnCR(PP_HWID, 07)
#endif

/* The EBC Configuration Register */
#define CFG_EBC_EPCR	PP_CALC_EBC0_CFG(PP_HWID)

/*-----------------------------------------------------------------------
 * Start addresses for the final memory configuration
 * (Set up by the startup code)
 * Please note that CFG_SDRAM_BASE _must_ start at 0
 */
#define CFG_SDRAM_BASE		0x00000000
#define CFG_FLASH_BASE		(0x0 - PP_(FLASH_SIZE, PP_HWID))

#ifdef PP_FEAT_JFFS2_ROOTFS
#  define CFG_MONITOR_BASE	0xFFFC0000	/* last 256 kB */
#  define CFG_MONITOR_LEN	(256 * 1024)	/* Reserve 256 kB for Monitor*/
#else
#  define CFG_MONITOR_BASE      0xFFFE0000      /* last 128 kB */
#  define CFG_MONITOR_LEN       (128 * 1024)    /* Reserve 128 kB for Monitor*/
#endif


/*-----------------------------------------------------------------------
 * FLASH organization
 */
#define CFG_FLASH_CFI		1	/* Flash is CFI conformant */
#define CFG_FLASH_USE_BUFFER_WRITE 1	/* use buffered writes (20x faster) */
#define CFG_FLASH_INCREMENT	0	/* there is only one bank */
#define CFG_MAX_FLASH_BANKS	1	/* max number of memory banks */
#define CFG_SECT_SIZE		(128*1024) /* sector size in bytes */
#define CFG_MAX_FLASH_SECT	(PP_(FLASH_SIZE, PP_HWID) / CFG_SECT_SIZE) /* max number of sectors on one chip */
#define CFG_FLASH_ERASE_TOUT	120000	/* Timeout for Flash Erase (in ms) */
#define CFG_FLASH_WRITE_TOUT	500	/* Timeout for Flash Write (in ms) */

/*
 * NOTE: The environment is placed via the linker script 'u-boot.lds' at the
 *       end of the boot monitor right before the reset vector.
 */
#ifdef CFG_ENV_IS_IN_FLASH
# define CFG_ENV_SECT_SIZE	(128*1024) /* environment sector total size */
# ifdef PP_FEAT_JFFS2_ROOTFS
#  define CFG_ENV_SIZE		1024	/* environment size */
# else
#  define CFG_ENV_SIZE		512	/* environment size */
# endif
# define CFG_ENV_ADDR		(CFG_MONITOR_BASE + CFG_MONITOR_LEN - CFG_ENV_SIZE - 0x10) /* let space for reset vector */
# define CFG_ENV_OFFSET		(CFG_ENV_ADDR - CFG_FLASH_BASE)

# define CFG_CRC_ADDR           (CFG_ENV_ADDR - 4)
# define CFG_CRC_OFFSET         (CFG_ENV_OFFSET - 4)
#endif

/*-----------------------------------------------------------------------
 * Cache Configuration
 */
#ifdef CONFIG_405EP
# define CFG_DCACHE_SIZE	16384
#else
# define CFG_DCACHE_SIZE	 8192
#endif
#define CFG_CACHELINE_SIZE	32
#if (CONFIG_COMMANDS & CFG_CMD_KGDB)
# define CFG_CACHELINE_SHIFT	5	/* log base 2 of the above value */
#endif

/*-----------------------------------------------------------------------
 * Init Memory Controller:
 *
 * BR0/1 and OR0/1 (FLASH)
 */

#define FLASH_BASE0_PRELIM	CFG_FLASH_BASE	/* FLASH bank #0	*/
#define FLASH_BASE1_PRELIM	0		/* FLASH bank #1	*/

/*-----------------------------------------------------------------------
 * Definitions for initial stack pointer and data area
 */
#undef CFG_INIT_DCACHE_CS	/* no stack in data cache memory */
#define CFG_INIT_RAM_ADDR	0x00df0000 /* Inside of SDRAM */
#define CFG_INIT_RAM_END	0x2000	/* End of used area in RAM */
#define CFG_GBL_DATA_SIZE	140	/* size in bytes reserved for initial data */
#define CFG_GBL_DATA_OFFSET	(CFG_INIT_RAM_END - CFG_GBL_DATA_SIZE)
#define CFG_INIT_SP_OFFSET	CFG_GBL_DATA_OFFSET

/*-----------------------------------------------------------------------
 * Internal Definitions
 *
 * Boot Flags
 */
#define BOOTFLAG_COLD	0x01		/* Normal Power-On: Boot from FLASH	*/
#define BOOTFLAG_WARM	0x02		/* Software reboot			*/

#if (CONFIG_COMMANDS & CFG_CMD_KGDB)
# define CONFIG_KGDB_BAUDRATE	230400	/* speed to run kgdb serial port */
# define CONFIG_KGDB_SER_INDEX	2	/* which serial port to use */
#endif

#ifdef CONFIG_405EP
# define PLLMR0_DEFAULT PP_PLLMR0_DEFAULT(PP_HWID)
# define PLLMR1_DEFAULT PP_PLLMR1_DEFAULT(PP_HWID)
# define DYNAMIC_PLL	PP_DYNAMIC_PLL(PP_HWID)
# if (PP_DYNAMIC_PLL(PP_HWID) == 1)
#  define PLLMR0_SLOW	PP_PLLMR0_SLOW(PP_HWID)
#  define PLLMR1_SLOW	PP_PLLMR1_SLOW(PP_HWID)
#  define PLLMR0_FAST	PP_PLLMR0_FAST(PP_HWID)
#  define PLLMR1_FAST	PP_PLLMR1_FAST(PP_HWID)
#  define CPU_CLK_SLOW	PP_CPU_CLK_SLOW(PP_HWID)
#  define CPU_CLK_FAST	PP_CPU_CLK_FAST(PP_HWID)
# endif
#endif

#endif	/* __CONFIG_H */
