#ifndef __KIRA100_H__
#define __KIRA100_H__

/******************************************************************
    AHB/APB device register mapping 
 *****************************************************************/

/* AHB */ 
#define CPE_AHB_BASE                    0x90100000
#define CPE_SRAMC_BASE                  0x90200000
#define CPE_SDRAMC_BASE                 0x90300000
#define CPE_AHBDMA_BASE                 0x90400000
#define CPE_APBDMA_BASE                 0x90500000
#define CPE_FTMAC2_BASE                 0x90700000
#define CPE_FML_BASE			0x90800000
#define CPE_FTMAC_BASE                  0x90900000
#define CPE_AES_BASE                    0x90A00000
#define CPE_USBDEV_BASE                 0x90b00000
#define CPE_LPC_BASE			0x91000000
#define CPE_USBOTG_BASE			0x91300000
#define CPE_EXTBUS_BASE			0x92300000
#define CPE_APBDEV_BASE			0x98000000
#define CPE_VSCREG_BASE                 0xa0000000
#define CPE_VSC_BASE                    CPE_VSCREG_BASE
#define CPE_VSCFB_BASE                  0xa0040000
#define CPE_INTRAM_BASE			0xb0000000

/* APB */
#define CPE_PMU_BASE                    0x98100000
#define CPE_UART1_BASE                  0x98200000
#define CPE_PWM_BASE                    0x98300000
#define CPE_TIMER_BASE                  0x98400000
#define CPE_WDT_BASE		        0x98500000
#define CPE_RTC_BASE		       	0x98600000
#define CPE_GPIO_BASE                   0x98700000
#define CPE_IC_BASE                     0x98800000
#define CPE_I2C5_BASE                   0x98900000
#define CPE_I2C1_BASE                   0x98a00000
#define CPE_I2C4_BASE                   0x98c00000
#define CPE_TACHO_BASE			0x98e00000
#define CPE_I2C3_BASE                   0x99000000
#define CPE_I2C2_BASE                   0x99300000
#define CPE_SSP_BASE                    0x99400000
#define CPE_I2C6_BASE			0x99500000
#define CPE_UART3_BASE                  0x99600000
#define CPE_ADC_BASE			0x99900000

#define CPE_HWID_BASE			0x82000000

/******************************************************************
 IRQ numbers
 *****************************************************************/

#define IRQ_AHB				0
#define IRQ_DMAC			1
#define IRQ_CPE_APB_DMA                 2
#define IRQ_I2C1                        3
#define IRQ_RESERVED                    4
#define IRQ_OTG				5
#define IRQ_SSP                         6
#define IRQ_UART3                       7
#define IRQ_PMU				8
#define IRQ_I2C4                        9
#define IRQ_UART1                       10
#define IRQ_I2C5                        11
#define IRQ_RTC                         12
#define IRQ_LPC                         13
#define IRQ_TIMER                       14 
#define IRQ_I2C3                        15
#define IRQ_WDT				16
#define IRQ_USBDEV                      17
#define IRQ_USBDEV_SUSP                 18
#define IRQ_MAC1                        19 
#define IRQ_I2C2                        20
#define IRQ_AES				21
#define IRQ_EXT_INT_0			22
#define IRQ_EXT_INT_1			23
#define IRQ_EXT_INT_2			24
#define IRQ_EXT_INT_3			25
#define IRQ_MAC2                        26
#define CPE_IRQ_VSC                     27
#define CPE_IRQ_VSC_GPIO                28
#define IRQ_FML		                29
#define IRQ_GPIO                        30
#define IRQ_TACHO			31

#define FIQ_AHB				32
#define FIQ_DMAC			33
#define FIQ_CPE_APB_DMA			34
#define FIQ_I2C1			35
#define FIQ_RESERVED			36
#define FIQ_OTG				37
#define FIQ_SSP				38
#define FIQ_UART3			39
#define FIQ_PMU				40
#define FIQ_I2C4			41
#define FIQ_UART1			42
#define FIQ_I2C5			43
#define FIQ_RTC				44
#define FIQ_LPC				45
#define FIQ_TIMER			46
#define FIQ_I2C3			47
#define FIQ_WDT				48
#define FIQ_USBDEV			49
#define FIQ_USBDEV_SUSP			50
#define FIQ_MAC1			51
#define FIQ_I2C2			52
#define FIQ_AES				53
#define FIQ_EXT_INT_0			54
#define FIQ_EXT_INT_1			55
#define FIQ_EXT_INT_2			56
#define FIQ_EXT_INT_3			57
#define FIQ_MAC2			58
#define CPE_FIQ_VSC			59
#define CPE_FIQ_VSC_GPIO		60
#define FIQ_FML				61
#define FIQ_GPIO			62
#define FIQ_TACHO			63

#define OFS2REG(x)	((x) / 4)
#define REG2OFS(x)	((x) * 4)

/******************************************************************
 Static Memory Controller (SMC) Registers
 *****************************************************************/
#define KIRA_SMC_REG_CONFIG_0		OFS2REG(0x00)
#define KIRA_SMC_REG_TIMING_0		OFS2REG(0x04)
#define KIRA_SMC_REG_CONFIG_1		OFS2REG(0x08)
#define KIRA_SMC_REG_TIMING_1		OFS2REG(0x0C)
#define KIRA_SMC_REG_CONFIG_2		OFS2REG(0x10)
#define KIRA_SMC_REG_TIMING_2		OFS2REG(0x14)
#define KIRA_SMC_REG_CONFIG_3		OFS2REG(0x18)
#define KIRA_SMC_REG_TIMING_3		OFS2REG(0x1C)
#define KIRA_SMC_REG_STATUS		OFS2REG(0x40)
#define KIRA_SMC_REG_REVISION		OFS2REG(0x80)
#define KIRA_SMC_REG_FEATURE		OFS2REG(0x84)

/* Various Register Bits */
#define KIRA_SMC_REG_CONFIG_BNK_EN_SHIFT	28
#define KIRA_SMC_REG_CONFIG_BNK_EN		(0x0001 << KIRA_SMC_REG_CONFIG_BNK_EN_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_BASE_SHIFT	15
#define KIRA_SMC_REG_CONFIG_BNK_BASE		(0x1FFF << KIRA_SMC_REG_CONFIG_BNK_BASE_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_WPROT_SHIFT	11
#define KIRA_SMC_REG_CONFIG_BNK_WPROT		(0x0001 << KIRA_SMC_REG_CONFIG_BNK_WPROT_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_TYP1_SHIFT	10
#define KIRA_SMC_REG_CONFIG_BNK_TYP1		(0x0001 << KIRA_SMC_REG_CONFIG_BNK_TYP1_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_TYP2_SHIFT	9
#define KIRA_SMC_REG_CONFIG_BNK_TYP2		(0x0001 << KIRA_SMC_REG_CONFIG_BNK_TYP2_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_TYP3_SHIFT	8
#define KIRA_SMC_REG_CONFIG_BNK_TYP3		(0x0001 << KIRA_SMC_REG_CONFIG_BNK_TYP3_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_SIZE_SHIFT	4
#define KIRA_SMC_REG_CONFIG_BNK_SIZE		(0x000F << KIRA_SMC_REG_CONFIG_BNK_SIZE_SHIFT)
#define KIRA_SMC_REG_CONFIG_BNK_MBW_SHIFT	0
#define KIRA_SMC_REG_CONFIG_BNK_MBW		(0x0003 << KIRA_SMC_REG_CONFIG_BNK_MBW_SHIFT)

#define KIRA_SMC_BNK_SIZE_32KB			0x0B
#define KIRA_SMC_BNK_SIZE_64KB			0x0C
#define KIRA_SMC_BNK_SIZE_128KB			0x0D
#define KIRA_SMC_BNK_SIZE_256KB			0x0E
#define KIRA_SMC_BNK_SIZE_512KB			0x0F
#define KIRA_SMC_BNK_SIZE_1MB			0x00
#define KIRA_SMC_BNK_SIZE_2MB			0x01
#define KIRA_SMC_BNK_SIZE_4MB			0x02
#define KIRA_SMC_BNK_SIZE_8MB			0x03
#define KIRA_SMC_BNK_SIZE_16MB			0x04
#define KIRA_SMC_BNK_SIZE_32MB			0x05
#define KIRA_SMC_BNK_SIZE_64MB			0x06

#define KIRA_SMC_BNK_MBW_8BIT			0x00
#define KIRA_SMC_BNK_MBW_16BIT			0x01
#define KIRA_SMC_BNK_MBW_32BIT			0x02

#define KIRA_SMC_REG_TIMING_ETRNA_SHIFT		28
#define KIRA_SMC_REG_TIMING_ETRNA		(0x000F << KIRA_SMC_REG_TIMING_ETRNA_SHIFT)
#define KIRA_SMC_REG_TIMING_EAT1_SHIFT		24
#define KIRA_SMC_REG_TIMING_EAT1		(0x000F << KIRA_SMC_REG_TIMING_EAT1_SHIFT)
#define KIRA_SMC_REG_TIMING_RBE_SHIFT		20
#define KIRA_SMC_REG_TIMING_RBE			(0x0001 << KIRA_SMC_REG_TIMING_RBE_SHIFT)
#define KIRA_SMC_REG_TIMING_AST_SHIFT		18
#define KIRA_SMC_REG_TIMING_AST			(0x0003 << KIRA_SMC_REG_TIMING_AST_SHIFT)
#define KIRA_SMC_REG_TIMING_CTW_SHIFT		16
#define KIRA_SMC_REG_TIMING_CTW			(0x0003 << KIRA_SMC_REG_TIMING_CTW_SHIFT)
#define KIRA_SMC_REG_TIMING_AT1_SHIFT		12
#define KIRA_SMC_REG_TIMING_AT1			(0x000F << KIRA_SMC_REG_TIMING_AT1_SHIFT)
#define KIRA_SMC_REG_TIMING_AT2_SHIFT		8
#define KIRA_SMC_REG_TIMING_AT2			(0x0003 << KIRA_SMC_REG_TIMING_AT2_SHIFT)
#define KIRA_SMC_REG_TIMING_WTC_SHIFT		6
#define KIRA_SMC_REG_TIMING_WTC 		(0x0003 << KIRA_SMC_REG_TIMING_WTC_SHIFT)
#define KIRA_SMC_REG_TIMING_AHT_SHIFT		4
#define KIRA_SMC_REG_TIMING_AHT 		(0x0003 << KIRA_SMC_REG_TIMING_AHT_SHIFT)
#define KIRA_SMC_REG_TIMING_TRNA_SHIFT		0
#define KIRA_SMC_REG_TIMING_TRNA 		(0x000F << KIRA_SMC_REG_TIMING_TRNA_SHIFT)

/******************************************************************
 Power Management Unit Registers
 *****************************************************************/

#define KIRA_PMU_REG_MINORREV		OFS2REG(0x00)
#define KIRA_PMU_REG_OSCC		OFS2REG(0x08)
#define KIRA_PMU_REG_PMODE	 	OFS2REG(0x0C)
#define KIRA_PMU_REG_PCR		OFS2REG(0x10)
#define KIRA_PMU_REG_PED		OFS2REG(0x14)
#define KIRA_PMU_REG_PEDSR		OFS2REG(0x18)

#define KIRA_PMU_REG_PSSR		OFS2REG(0x20)
#define KIRA_PMU_REG_PGSR		OFS2REG(0x24)
#define KIRA_PMU_REG_MFPSR		OFS2REG(0x28)
#define KIRA_PMU_REG_MISC		OFS2REG(0x2C)
#define KIRA_PMU_REG_PDLLCR0		OFS2REG(0x30)
#define KIRA_PMU_REG_PDLLCR1		OFS2REG(0x34)
#define KIRA_PMU_REG_AHBMCLKOFF		OFS2REG(0x38)
#define KIRA_PMU_REG_APBMCLKOFF		OFS2REG(0x3C)
#define KIRA_PMU_REG_DCSRCR0		OFS2REG(0x40)
#define KIRA_PMU_REG_DCSRCR1		OFS2REG(0x44)
#define KIRA_PMU_REG_DCSRCR2		OFS2REG(0x48)
#define KIRA_PMU_REG_SDRAMHTC		OFS2REG(0x4C)
#define KIRA_PMU_REG_PSPR0		OFS2REG(0x50)
#define KIRA_PMU_REG_PSPR1		OFS2REG(0x54)
#define KIRA_PMU_REG_PSPR2		OFS2REG(0x58)
#define KIRA_PMU_REG_PSPR3		OFS2REG(0x5C)
#define KIRA_PMU_REG_PSPR4		OFS2REG(0x60)
#define KIRA_PMU_REG_PSPR5		OFS2REG(0x64)
#define KIRA_PMU_REG_PSPR6		OFS2REG(0x68)
#define KIRA_PMU_REG_PSPR7		OFS2REG(0x6C)
#define KIRA_PMU_REG_PSPR8		OFS2REG(0x70)
#define KIRA_PMU_REG_PSPR9		OFS2REG(0x74)
#define KIRA_PMU_REG_PSPR10		OFS2REG(0x78)
#define KIRA_PMU_REG_PSPR11		OFS2REG(0x7C)
#define KIRA_PMU_REG_PSPR12		OFS2REG(0x80)
#define KIRA_PMU_REG_PSPR13		OFS2REG(0x84)
#define KIRA_PMU_REG_PSPR14		OFS2REG(0x88)

#define KIRA_PMU_REG_AHBDMA1		OFS2REG(0x90)
#define KIRA_PMU_REG_AHBDMA2		OFS2REG(0x94)
#define KIRA_PMU_REG_JPSET		OFS2REG(0x9C)

#define KIRA_PMU_REG_UART1_TX_DMA	OFS2REG(0xA8)
#define KIRA_PMU_REG_UART1_RX_DMA	OFS2REG(0xAC)

#define KIRA_PMU_REG_SSP_TX_DMA		OFS2REG(0xBC)
#define KIRA_PMU_REG_SSP_RX_DMA		OFS2REG(0xC0)
#define KIRA_PMU_REG_UART3_TX_DMA	OFS2REG(0xC4)
#define KIRA_PMU_REG_UART3_RX_DMA	OFS2REG(0xC8)
#define KIRA_PMU_REG_USBD_DMA		OFS2REG(0xCC)

#define KIRA_PMU_REG_PORTMUX		OFS2REG(0x100)

#define KIRA_PMU_REG_MCPA_IO_1		OFS2REG(0x114)
#define KIRA_PMU_REG_MCPA_IO_2		OFS2REG(0x118)
#define KIRA_PMU_REG_MCPA_IO_3		OFS2REG(0x11C)
#define KIRA_PMU_REG_MCPA_IO_7		OFS2REG(0x12C)
#define KIRA_PMU_REG_USBD_OTG_PHY	OFS2REG(0x130)

#define CPE_PMU_SIZE			0x134 /* register space for pmu */

/* Various Register Bits */
#define KIRA_PMU_REG_MISC_PWMCLKDIV_SHIFT 28
#define KIRA_PMU_REG_MISC_PWMCLKDIV	  (0x0F << KIRA_PMU_REG_MISC_PWMCLKDIV_SHIFT)

#define KIRA_PMU_REG_MINORREV_MINORREV	  0x01

/******************************************************************
 Timer Register offsets
 *****************************************************************/

#define KIRA_TMR_TM1_COUNTER		OFS2REG(0x00)
#define KIRA_TMR_TM1_LOAD		OFS2REG(0x04)
#define KIRA_TMR_TM1_MATCH1 		OFS2REG(0x08)
#define KIRA_TMR_TM1_MATCH2 		OFS2REG(0x0C)
#define KIRA_TMR_TM2_COUNTER		OFS2REG(0x10)
#define KIRA_TMR_TM2_LOAD		OFS2REG(0x14)
#define KIRA_TMR_TM2_MATCH1 		OFS2REG(0x18)
#define KIRA_TMR_TM2_MATCH2 		OFS2REG(0x1C)
#define KIRA_TMR_TM3_COUNTER		OFS2REG(0x20)
#define KIRA_TMR_TM3_LOAD		OFS2REG(0x24)
#define KIRA_TMR_TM3_MATCH1 		OFS2REG(0x28)
#define KIRA_TMR_TM3_MATCH2 		OFS2REG(0x2C)
#define KIRA_TMR_CONTROL    		OFS2REG(0x30)
#define KIRA_TMR_IRQ_STATE    		OFS2REG(0x34)
#define KIRA_TMR_IRQ_MASK    		OFS2REG(0x38)

#define KIRA_TMR_CR_TM1_ENABLE	        (1 <<  0)
#define KIRA_TMR_CR_TM1_CLOCK	        (1 <<  1)
#define KIRA_TMR_CR_TM1_OF	        (1 <<  2)
#define KIRA_TMR_CR_TM2_ENABLE	        (1 <<  3)
#define KIRA_TMR_CR_TM2_CLOCK	        (1 <<  4)
#define KIRA_TMR_CR_TM2_OF	        (1 <<  5)
#define KIRA_TMR_CR_TM3_ENABLE	        (1 <<  6)
#define KIRA_TMR_CR_TM3_CLOCK	        (1 <<  7)
#define KIRA_TMR_CR_TM3_OF	        (1 <<  8)
#define KIRA_TMR_CR_TM1_UP	        (1 <<  9)
#define KIRA_TMR_CR_TM2_UP	        (1 << 10)
#define KIRA_TMR_CR_TM3_UP	        (1 << 11)

#define KIRA_TMR_IRQ_TM1_MATCH1		(1 <<  0)
#define KIRA_TMR_IRQ_TM1_MATCH2		(1 <<  1)
#define KIRA_TMR_IRQ_TM1_OF		(1 <<  2)
#define KIRA_TMR_IRQ_TM2_MATCH1		(1 <<  3)
#define KIRA_TMR_IRQ_TM2_MATCH2		(1 <<  4)
#define KIRA_TMR_IRQ_TM2_OF		(1 <<  5)
#define KIRA_TMR_IRQ_TM3_MATCH1		(1 <<  6)
#define KIRA_TMR_IRQ_TM3_MATCH2		(1 <<  7)
#define KIRA_TMR_IRQ_TM3_OF		(1 <<  8)

/******************************************************************
 Interrupt controller offsets
 *****************************************************************/

#define KIRA_INTC_IRQ_SOURCE		OFS2REG(0x00)
#define KIRA_INTC_IRQ_ENABLE		OFS2REG(0x04)
#define KIRA_INTC_IRQ_CLEAR		OFS2REG(0x08)
#define KIRA_INTC_IRQ_MODE		OFS2REG(0x0C)
#define KIRA_INTC_IRQ_LEVEL		OFS2REG(0x10)
#define KIRA_INTC_IRQ_STATUS		OFS2REG(0x14)

#define KIRA_INTC_FIQ_SOURCE		OFS2REG(0x20)
#define KIRA_INTC_FIQ_ENABLE		OFS2REG(0x24)
#define KIRA_INTC_FIQ_CLEAR		OFS2REG(0x28)
#define KIRA_INTC_FIQ_MODE		OFS2REG(0x2C)
#define KIRA_INTC_FIQ_LEVEL		OFS2REG(0x30)
#define KIRA_INTC_FIQ_STATUS		OFS2REG(0x34)

#define KIRA_INTC_REVISION		OFS2REG(0x50)
#define KIRA_INTC_FEATURE		OFS2REG(0x54)
#define KIRA_INTC_FEATURE_IRQ_DEBOUNCE	OFS2REG(0x58)
#define KIRA_INTC_FEATURE_FIQ_DEBOUNCE	OFS2REG(0x5C)

/* KIRA IRQ table bits */
#define KIRA_IRQ_TACHO			(1 << 31)
#define KIRA_IRQ_GPIO			(1 << 30)
#define KIRA_IRQ_FML			(1 << 29)
#define KIRA_IRQ_I2C6			(1 << 29)
#define KIRA_IRQ_VSC_GPIO		(1 << 28)
#define KIRA_IRQ_VSC_IRQ		(1 << 27)
#define KIRA_IRQ_MAC2			(1 << 26)
#define KIRA_IRQ_EXT_INT3		(1 << 25)
#define KIRA_IRQ_EXT_INT2		(1 << 24)
#define KIRA_IRQ_EXT_INT1		(1 << 23)
#define KIRA_IRQ_EXT_INT0		(1 << 22)
#define KIRA_IRQ_AES			(1 << 21)
#define KIRA_IRQ_I2C2			(1 << 20)
#define KIRA_IRQ_MAC			(1 << 19)
#define KIRA_IRQ_USBD2_SUSPEND		(1 << 18)
#define KIRA_IRQ_USBD2			(1 << 17)
#define KIRA_IRQ_WDT			(1 << 16)
#define KIRA_IRQ_I2C3			(1 << 15)
#define KIRA_IRQ_TIMER			(1 << 14)
#define KIRA_IRQ_LPC			(1 << 13)
#define KIRA_IRQ_RTC			(1 << 12)
#define KIRA_IRQ_I2C5			(1 << 11)
#define KIRA_IRQ_UART1			(1 << 10)
#define KIRA_IRQ_I2C4			(1 <<  9)
#define KIRA_IRQ_PMU			(1 <<  8)
#define KIRA_IRQ_UART3			(1 <<  7)
#define KIRA_IRQ_SSP			(1 <<  6)
#define KIRA_IRQ_USBOTG			(1 <<  5)

#define KIRA_IRQ_I2C1			(1 <<  3)
#define KIRA_IRQ_APB_DMA		(1 <<  2)
#define KIRA_IRQ_DMAC			(1 <<  1)
#define KIRA_IRQ_AHBC			(1 <<  0)

/******************************************************************
 Watchdog Register offsets
 *****************************************************************/

#define KIRA_WDT_REG_WDCOUNTER		OFS2REG(0x00)
#define KIRA_WDT_REG_WDLOAD		OFS2REG(0x04)
#define KIRA_WDT_REG_WDRESTART		OFS2REG(0x08)
#define KIRA_WDT_REG_WDCR		OFS2REG(0x0C)
#define KIRA_WDT_REG_WDSTATUS		OFS2REG(0x10)

/******************************************************************
 GPIO Registers
 *****************************************************************/

#define KIRA_GPIO_DATA_OUT		OFS2REG(0x00)
#define KIRA_GPIO_DATA_IN		OFS2REG(0x04)
#define KIRA_GPIO_PIN_DIR		OFS2REG(0x08)
#define KIRA_GPIO_PIN_BYPASS		OFS2REG(0x0C)
#define KIRA_GPIO_DATA_SET		OFS2REG(0x10)
#define KIRA_GPIO_DATA_CLEAR		OFS2REG(0x14)
#define KIRA_GPIO_PIN_PULL_ENABLE	OFS2REG(0x18)
#define KIRA_GPIO_PIN_PULL_TYPE		OFS2REG(0x1C)
#define KIRA_GPIO_INTR_ENABLE		OFS2REG(0x20)
#define KIRA_GPIO_INTR_RAW_STATE	OFS2REG(0x24)
#define KIRA_GPIO_INTR_MASKED_STATE	OFS2REG(0x28)
#define KIRA_GPIO_INTR_MASK		OFS2REG(0x2C)
#define KIRA_GPIO_INTR_CLEAR		OFS2REG(0x30)
#define KIRA_GPIO_INTR_TRIGGER		OFS2REG(0x34)
#define KIRA_GPIO_INTR_BOTH		OFS2REG(0x38)
#define KIRA_GPIO_INTR_RISE_NEG		OFS2REG(0x3C)
#define KIRA_GPIO_INTR_BOUNCE_ENABLE	OFS2REG(0x40)
#define KIRA_GPIO_INTR_BOUNCE_PRESCALE	OFS2REG(0x44)

#define KIRA_GPIO_SIZE			0x48 /* register space for gpio */

/*
 * Macros for retrieving major and minor revision of KIRA100
 *
 */
 
#define KIRA_MAKEMAJORMINOR(major, minor)   (((major & 0xf) << 4) | (minor & 0xf))
#define KIRA_MAJOR(x)                       ((x >> 4) & 0xf)
#define KIRA_MINOR(x)                       (x & 0xf)

#endif /* __KIRA100_H__ */
