#!/usr/bin/bash
#################################################################
#	Complete RWC2 Package installation script		#
#################################################################

usage()
{
 	echo "Incorrect option selected. Please retry....."
        echo "This mode of installation is not supported for Raid Web Console 2"
        echo "usage: "./install.sh""

}

uninstall_old_rwc2()
{
	echo "A version of Raid Web Console 2 is found on this system."
	echo "Uninstalling the existing version of Raid Web Console 2."

	/opt/RaidWebConsole2/uninstaller.sh

	if [ $? -ne 0 ]; then

		echo "Installation of Raid Web Console 2 got aborted as the uninstallation of existing Raid Web Console 2 did not complete successfully."
                exit 1;
        fi

        echo "Uninstallation of previous package got completed."

	sleep 20

	echo "";
	echo "";
	echo "";
	echo "";
	echo "";
	echo "";

	sleep 20
	
	echo "";
	echo "";
	echo "";
	echo "";
	echo "";

	sleep 20
}

if [ $# == 0 ]; then
	
	# If user executes install.sh without any
	# arguments then default is full installation.

	echo "Starting complete installation of Raid Web Console 2."

fi

if [ $# = 1 ]; then
		usage
		exit 0;
fi

PKGNAME=RaidWebConsole2	
PKGFILE=""
CURVER=`/usr/bin/pkginfo -l ${PKGNAME} 2>&1 | grep "VERSION:" | awk '{ print $2 }' | cut -f1 -d"-"`

PKGFILE=$PKGNAME-*.pkg
UPDATEVER=`/usr/bin/pkginfo -l -d ${PKGFILE} 2>&1 | grep "VERSION:" | awk '{ print $2 }' | cut -f1 -d "-"`

/usr/bin/pkginfo -ql ${PKGNAME} 2>/dev/null

if [ $? -ne 1 ]; then

	if [ "${CURVER}" = "${UPDATEVER}" ]; then
	
		installedMinorVer=`/usr/bin/pkginfo -l ${PKGNAME} 2>&1 | grep "VERSION:" | awk '{ print $2 }' | cut -f2 -d"-"`

		updatingMinorVer=`/usr/bin/pkginfo -l -d ${PKGFILE} 2>&1 | grep "VERSION:" | awk '{ print $2 }' | cut -f2 -d "-"`

		if [ "${installedMinorVer}" = "${updatingMinorVer}" ]; then
	
			 echo "The version of package you are trying to install is already installed on this machine."
		
			exit 0

		elif expr "${installedMinorVer}" \> "${updatingMinorVer}" 2>/dev/null >/dev/null
		then
			echo "The version of Raid Web Console 2 that is installed in this system is higher than the version you are trying to install."
			echo "Please uninstall the existing version before proceeding with the current installation."

			exit 1;

		elif expr "${installedMinorVer}" \< "${updatingMinorVer}" 2>/dev/null >/dev/null
		then
			uninstall_old_rwc2;
		fi

	elif expr "${CURVER}" \> "${UPDATEVER}" 2>/dev/null >/dev/null
	then
		echo "The version of Raid Web Console 2 that is installed in this system is higher than the version you are trying to install."

		echo "Please uninstall the existing version before proceeding with the current installation."

		exit 1;

	elif expr "${CURVER}" \< "${UPDATEVER}" 2>/dev/null >/dev/null
	then
		uninstall_old_rwc2;
	fi
fi


INSTALL_LOG="/tmp/lsi_install.log"
install_pkg()
{
	PKGNAME=$1	
	PKGFILE=""
	CURVER=`/usr/bin/pkginfo -l ${PKGNAME} 2>&1 | grep "VERSION:" | awk '{ print $2 }'`
	if [ -f $1-*.pkg ] ; then
		PKGFILE=$1-*.pkg
        #elif [ $1 = "CmdTool2" ] ; then
        #        PKGFILE=$1.pkg
        #fi	

	if [ "${PKGFILE}" = "" ]; then
		echo "Couldn't find an appropriate installation package for $1"
		exit 1	
	else
		UPDATEVER=`/usr/bin/pkginfo -l -d ${PKGFILE} 2>&1 | grep "VERSION:" | awk '{ print $2 }'`		
		TEST_VER=`echo $UPDATEVER " " $CURVER | awk '$1==$2 {print "TRUE"}'`	
		echo "Installing ${PKGNAME} Ver ${UPDATEVER} : "  	
		if [ "${TEST_VER}" = "TRUE" ] ; then
			echo " [ Already Installed ] "
			return 0
		fi

		if [ "${CURVER}" != "" ]  ; then
			echo "${PKGNAME} ver ${CURVER} is already installed"
			echo "Please uninstall existing ${PKGNAME} and continue installation"
			echo "Exiting..."
			exit 1	
		
		else		
		      #if [ "${PKGFILE}" = "CmdTool2.pkg" ] ; then
                               # pkgadd -d ${PKGFILE} SOLCMDTOOL2 
                               # if [ $? -ne 0 ] ; then
                               #         echo " [ Installation Failed ] "
                               # else
                               #         echo " [ Installation Ok ] "
                               # fi
                       # else
                                pkgadd -d ${PKGFILE} ${PKGNAME}
                                if [ $? -ne 0 ] ; then
                                        echo " [ Installation Failed ] "
                                else
                                        echo " [ Installation Ok ] "
                                fi
                        fi
					
		fi		
	fi

}

INSTALL_LIST="RaidWebConsole2 sassnmp sasirsnmp" 

if [ "$1" = "-c" ]; then
	INSTALL_LIST="RaidWebConsole2"

fi

for i in ${INSTALL_LIST}
do
	install_pkg $i
done


if [ -d "/opt/RaidWebConsole2" ]; then

	if [ "$1" = "-s" ]; then

		echo "Remove the Network capability plugin from the Framework";
		#svcadm disable -t RWC2Monitor
		#sleep 10
		svcadm disable -t RWC2Framework

		rm -rf /opt/RaidWebConsole2/Framework/plugins/NetworkCapabilityPlugin.class

		svcadm enable RWC2Framework
		#sleep 3
		#svcadm enable RWC2Monitor
	fi

	if [ "$1" = "-c" ]; then
	
		#svcadm disable -t RWC2Monitor
		#sleep 5
		svcadm disable -t RWC2Framework

		#svcadm disable RWC2Monitor
		#sleep 3
		svcadm disable RWC2Framework
		#sleep 3

		#svccfg delete -f RWC2Monitor
		svccfg delete -f RWC2Framework

		rm -rf /opt/RaidWebConsole2/Framework
		rm -rf /opt/RaidWebConsole2/MegaMonitor
		rm -rf /opt/RaidWebConsole2/MegaPopup
		rm -rf /opt/RaidWebConsole2/Common

		sed 's/\/opt\/RaidWebConsole2\/MegaPopup\/popup&//g' /etc/profile >/etc/profile2
		mv /etc/profile2 /etc/profile

	fi

	#if [ "$1" != "-c" ]; then
	#	cd /opt/RaidWebConsole2/MegaPopup;
	#	./popup > /dev/null;
	#	cd - >/dev/null;
	#fi

	cp "Intel RAID_splash-art_2 copy.gif" /opt/RaidWebConsole2/docs/wwhelp/images
fi

#Change the directory permissions of /usr/lib directory.
chmod -R +x /usr/lib 2>/dev/null

. /opt/RaidWebConsole2/MegaPopup/popup&
