#!/bin/sh

# snmpsubagentinstall.sh

if [ -f ../../../ License.txt ]; then

   cat ../../../License.txt | more

elif [ -f ./license.txt ]; then

   cat ./license.txt | more

else

    echo -n "License not found.."

fi

reply=
while [[ $reply != "Y" && $reply != "y" && $reply != "N" && $reply != "n" ]]; do
    echo "Accept? (Y/N)"
    read reply
done
if [[ $reply = "N" || $reply = "n" ]]; then
  exit
fi

# unalias following commands from any previous one

unalias echo 2>/dev/null
unalias grep 2>/dev/null
unalias chmod 2>/dev/null
unalias rpm 2>/dev/null
unalias uname 2>/dev/null

UNINSTALL_SNMP="NO"
INSTALL_SNMP="NO"

SNMP_SA=`rpm -q snmpsa-2.0-1`
if [ $? -eq 0 ]; then
	echo "Intel(R) SNMP Subagent "${SNMP_SA}" already installed."
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-1.5-2`
if [ $? -eq 0 ]; then
	echo "Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first executing snmpsubagent_uninstall.sh "
	exit 1
fi

SNMP_SA=`rpm -q snmpsa-1.0-1`
if [ $? -eq 0 ]; then
	echo "Intel(R) SNMP Subagent "${SNMP_SA}" already installed. Please uninstall it first executing snmpsubagent_uninstall.sh "
	exit 1
fi

echo "Installing Intel(R) SNMP Subagent..."

if [ -f "/etc/SuSE-release" ] ; then 
	## Check for SLES 10
	grep "VERSION *= *10" /etc/SuSE-release > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		## Check whether OS net-snmp is installed.

		NET_SNMP=`rpm -q net-snmp`
		if [ $? -eq 1 ]; then
			echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
			echo "Aborting installation of Intel(R) SNMP Subagent."
			exit 1		
		fi
	else
		## Check whether net-snmp is installed

		NET_SNMP=`rpm -q net-snmp`
		if [ $? -eq 1 ]; then
			echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
			echo "Aborting installation of Intel(R) SNMP Subagent."
			exit 1		
		elif [[ $NET_SNMP != *isms* ]]; then
			## Get the first version numbers ex. 5.1.4
			NET_SNMP_VER=${NET_SNMP##net-snmp-}
			NET_SNMP_VER=${NET_SNMP_VER%%-*}
			NET_SNMP_VER_REL=${NET_SNMP_VER#5.1.}
			NET_SNMP_VER_REL=${NET_SNMP_VER_REL%.*}
		
			if [[ "${NET_SNMP_VER%.*}" == 5.1* ]] && [ "${NET_SNMP_VER_REL}" -le 4 ] || [ "${NET_SNMP_VER%.*}" = "5.0" ] ; then
				echo "Found net-snmp version "${NET_SNMP_VER}" on this system."
				echo "Intel(R) SNMP Subagent requires ISMS net-snmp version 5.1.4."
				echo -n "Would you like to uninstall the default net-snmp packages and install ISMS net-snmp 5.1.4 available with the Subagent? (Enter 'y' to continue or any other key to abort the installation of the Intel(R) SNMP Sub-Agent.) "

				read answer
				answer=`echo ${answer} | tr a-z A-Z `
				if [ "${answer}" = "Y" ]; then
					UNINSTALL_SNMP="YES"
					INSTALL_SNMP="YES"
				else
					echo "ISMS net-snmp 5.1.4 required for Intel(R) SNMP Subagent."
					echo "Aborting installation of Intel(R) SNMP Subagent."
					exit 1
				fi
			fi
		fi

		if [ "${UNINSTALL_SNMP}" = "YES" ]; then
			echo "Uninstalling, please wait..."
			INSTALL_SNMP="YES"
			if [ -f "/etc/SuSE-release" ]; then
				NET_SNMP_PERL=`rpm -q perl-SNMP`
				if [ $? -eq 0 ]; then
					rpm -e --nodeps ${NET_SNMP_PERL}
					echo "Uninstalled "${NET_SNMP_PERL}
				fi
			else
				NET_SNMP_PERL=`rpm -q net-snmp-perl`
				if [ $? -eq 0 ]; then
					rpm -e --nodeps ${NET_SNMP_PERL}
					echo "Uninstalled "${NET_SNMP_PERL}
				fi
			fi

			NET_SNMP_DEVEL=`rpm -q net-snmp-devel`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP_DEVEL}
				echo "Uninstalled "${NET_SNMP_DEVEL}
			fi
	
			NET_SNMP_UTILS=`rpm -q net-snmp-utils`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP_UTILS}
				echo "Uninstalled "${NET_SNMP_UTILS}
			fi

			NET_SNMP=`rpm -q net-snmp`
			if [ $? -eq 0 ]; then
				rpm -e --nodeps ${NET_SNMP}
				echo "Uninstalled "${NET_SNMP}
			fi

			NET_SNMP_LIBS=`rpm -q net-snmp-libs | sort -u`
			echo ${NET_SNMP_LIBS} | grep "not installed" > /dev/null 2>&1
			if [ $? -eq 1 ]; then
				rpm -e --nodeps --allmatches ${NET_SNMP_LIBS}
				echo "Uninstalled "${NET_SNMP_LIBS}
			fi
			echo
		fi

		if [ "${INSTALL_SNMP}" = "YES" ]; then
			echo "Installing ISMS net-snmp 5.1.4"
		
			uname -a | grep x86_64 > /dev/null 2>&1
			if [ $? -eq 0 ]; then
			
				rpm -ivh ./suse/x86_64/9.0/net-snmp/net-snmp-5.1.4-0.1.isms.sles9.x86_64.rpm
				rpm -ivh ./suse/x86_64/9.0/net-snmp/net-snmp-devel-5.1.4-0.1.isms.sles9.x86_64.rpm
				rpm -ivh ./suse/x86_64/9.0/net-snmp/perl-SNMP-5.1.4-0.1.isms.sles9.x86_64.rpm
			else
				rpm -ivh ./suse/ia32/9.0/net-snmp/net-snmp-5.1.4-0.1.isms.sles9.i586.rpm
				rpm -ivh ./suse/ia32/9.0/net-snmp/net-snmp-devel-5.1.4-0.1.isms.sles9.i586.rpm
				rpm -ivh ./suse/ia32/9.0/net-snmp/perl-SNMP-5.1.4-0.1.isms.sles9.i586.rpm
			fi
		
		fi

	# End of SLES 10 check's else condition
	fi 
	

else
	# OS is not SuSE. ISMS net-snmp is not required.
	
	## Check whether OS net-snmp is installed.

	NET_SNMP=`rpm -q net-snmp`
	if [ $? -eq 1 ]; then
		echo "Intel(R) SNMP Subagent requires net-snmp package to be installed on the system."
		echo "Aborting installation of Intel(R) SNMP Subagent."
		exit 1		
	fi
	
fi

SNMP_PID=`pidof snmpd`
if [ -z "${SNMP_PID}" ]; then
	echo "Starting snmpd service ..."
	/etc/init.d/snmpd start
	SNMPD_STAT=$?
	if [ "${SNMPD_STAT}" -ne 0 ]; then
		echo "Couldn't start snmpd service, exiting install"
		## Exit and return the obtained error code.
		exit ${SNMPD_STAT}
	fi
fi


#Check if RedHat  / SUSE

if [ -f "/etc/SuSE-release" ]  
	then
	## Check for SLES 10
	grep "VERSION *= *10" /etc/SuSE-release > /dev/null 2>&1
	if [ $? -eq 0 ]; then
		## Check for 32 / x64
		uname -a|grep x86_64 > /dev/null 2>&1
		if [ $? -eq 0 ]; then
			## Create symlinks and install without checking dependencies.
			if [ ! -e "/usr/lib64/librpm-4.1.so" ]
				then
				ln -s /usr/lib64/librpm-4.4.so /usr/lib64/librpm-4.1.so
				ln -s /usr/lib64/librpmdb-4.4.so /usr/lib64/librpmdb-4.1.so
				ln -s /usr/lib64/librpmio-4.4.so /usr/lib64/librpmio-4.1.so
			fi
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.10 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.10 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.10 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.10 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.10 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.10 /usr/lib64/libnetsnmptrapd.so.5
			fi
			rpm -ivh --nodeps ./suse/x64/10/CacheRiver*.i586.rpm
			rpm -ihv --nodeps ./suse/x64/10/snmpsa*.x86_64.rpm
                        chkconfig snmpd 345
                        chkconfig snmpsa 345
		else
			## Create symlinks and install without checking dependencies.
			if [ ! -e "/usr/lib/librpm-4.1.so" ]
				then
				ln -s /usr/lib/librpm-4.4.so /usr/lib/librpm-4.1.so
				ln -s /usr/lib/librpmdb-4.4.so /usr/lib/librpmdb-4.1.so
				ln -s /usr/lib/librpmio-4.4.so /usr/lib/librpmio-4.1.so
			fi
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5
			fi
                        rpm -ivh --nodeps ./suse/ia32/10/CacheRiver*.rpm
			rpm -ihv --nodeps ./suse/ia32/10/snmpsa-2.0-1.i586.rpm
		        chkconfig snmpd 345	
                        chkconfig snmpsa 345
		fi
	else
		## Check for 32 / x64
		ARCH=`uname -a|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.8 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.8 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.8 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.8 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.8 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.8 /usr/lib64/libnetsnmptrapd.so.5
			fi
			rpm -ivh --nodeps ./suse/x64/11/CacheRiver*.rpm 
			rpm -ihv --nodeps ./suse/x64/11/snmpsa*.x86_64.rpm
                        chkconfig snmpd 345
                        chkconfig snmpsa 345
                      
		else
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.8 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.8 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.8 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.8 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.8 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.8 /usr/lib/libnetsnmptrapd.so.5
			fi
			rpm -ivh --nodeps ./suse/ia32/11/CacheRiver*.rpm
			rpm -ihv --nodeps ./suse/ia32/11/snmpsa-2.0-1.i586.rpm
			chkconfig snmpd 345
                        chkconfig snmpsa 345		
                 fi
	fi
else
	#Check RHEL Version
	RH_RELEASE=`rpm -q redhat-release`
	if [[ $RH_RELEASE == redhat-release-5Server* ]]
		then
		#Check if EM64
		ARCH=`uname -a|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#Create softlinks for librpm-4.2(64) and do a force installation
			if [ ! -e "/usr/lib64/librpm-4.2.so" ]
				then
				ln -s /usr/lib64/librpm.so /usr/lib64/librpm-4.2.so
				ln -s /usr/lib64/librpmdb.so /usr/lib64/librpmdb-4.2.so
				ln -s /usr/lib64/librpmio.so /usr/lib64/librpmio-4.2.so
			fi
			if [ ! -e "/lib64/libcrypto.so.4" ]
				then
				ln -s /lib64/libcrypto.so.6 /lib64/libcrypto.so.4
			fi
			if [ ! -e "/usr/lib64/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib64/libnetsnmpagent.so.10 /usr/lib64/libnetsnmpagent.so.5
				ln -s /usr/lib64/libnetsnmphelpers.so.10 /usr/lib64/libnetsnmphelpers.so.5
				ln -s /usr/lib64/libnetsnmpmibs.so.10 /usr/lib64/libnetsnmpmibs.so.5
				ln -s /usr/lib64/libnetsnmp.so.10 /usr/lib64/libnetsnmp.so.5				
				ln -s /usr/lib64/libsnmp.so.10 /usr/lib64/libsnmp.so.5
				ln -s /usr/lib64/libnetsnmptrapd.so.10 /usr/lib64/libnetsnmptrapd.so.5

				#Attempt to create links for 32 bit as well
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5
			fi
			rpm -ivh --nodeps ./rhlinux/x64/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/x64/el5.0/snmpsa*.x86_64.rpm
		        chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on  
                  else
			#Create softlinks for librpm-4.2(32) and do a force installation
			if [ ! -e "/usr/lib/librpm-4.2.so" ]
				then
				ln -s /usr/lib/librpm.so /usr/lib/librpm-4.2.so
				ln -s /usr/lib/librpmdb.so /usr/lib/librpmdb-4.2.so
				ln -s /usr/lib/librpmio.so /usr/lib/librpmio-4.2.so
			fi
			if [ ! -e "/lib/libcrypto.so.4" ]
				then
				ln -s /lib/libcrypto.so.6 /lib/libcrypto.so.4
			fi
			if [ ! -e "/usr/lib/libnetsnmpagent.so.5" ]; then
				ln -s  /usr/lib/libnetsnmpagent.so.10 /usr/lib/libnetsnmpagent.so.5
				ln -s /usr/lib/libnetsnmphelpers.so.10 /usr/lib/libnetsnmphelpers.so.5
				ln -s /usr/lib/libnetsnmpmibs.so.10 /usr/lib/libnetsnmpmibs.so.5
				ln -s /usr/lib/libnetsnmp.so.10 /usr/lib/libnetsnmp.so.5				
				ln -s /usr/lib/libsnmp.so.10 /usr/lib/libsnmp.so.5
				ln -s /usr/lib/libnetsnmptrapd.so.10 /usr/lib/libnetsnmptrapd.so.5			
			fi
			rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el5.0/snmpsa-2.0-1.i386.rpm
                        chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on
		fi
	elif [[ $RH_RELEASE == redhat-release-4AS* ]]
		then
		#Check if EM64
		ARCH=`uname -a|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			#Create softlinks for librpm-4.2(64) and do a force installation
			if [ ! -e "/usr/lib64/librpm-4.2.so" ]
				then
				ln -s /usr/lib64/librpm.so /usr/lib64/librpm-4.2.so
				ln -s /usr/lib64/librpmdb.so /usr/lib64/librpmdb-4.2.so
				ln -s /usr/lib64/librpmio.so /usr/lib64/librpmio-4.2.so
			fi
			rpm -ivh --nodeps ./rhlinux/x86_64/el5.0/CacheRiver*.i386.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el3.0/snmpsa-2.0-1.el3.x86_64.rpm
                        chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on 
		else
			#Create softlinks for librpm-4.2(32) and do a force installation
			if [ ! -e "/usr/lib/librpm-4.2.so" ]
				then
				ln -s /usr/lib/librpm.so /usr/lib/librpm-4.2.so
				ln -s /usr/lib/librpmdb.so /usr/lib/librpmdb-4.2.so
				ln -s /usr/lib/librpmio.so /usr/lib/librpmio-4.2.so
			fi
			rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el3.0/snmpsa-2.0-1.el3.i386.rpm
	                chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on
        	fi
	else
		#Check if EM64
		ARCH=`uname -a|grep x86_64 > /dev/null 2>&1`
		if [ $? = 0 ]
			then
			rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/x86_64/el3.0/snmpsa-2.0-1.el3.x86_64.rpm
                        chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on 
		else
                        rpm -ivh --nodeps ./rhlinux/ia32/el5.0/CacheRiver*.rpm
			rpm -ihv --nodeps ./rhlinux/ia32/el5.0/snmpsa-2.0-1.el3.i386.rpm
                        chkconfig --level 345 snmpd on
                        chkconfig --level 345 snmpsa on  
		fi
	fi
fi
cp -R ./docs  /usr/local/snmpsa/
cp ./snmpsubagent_uninstall.sh  /usr/bin/
chmod +x /usr/bin/snmpsubagent_uninstall.sh

echo "Intel(R) SNMP Subagent installed successfully!"
exit 0
