/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __UPDATECALLBACKBASE_H_
#define __UPDATECALLBACKBASE_H_

#include <os/include/cr_osal.h>

namespace Module
{
	namespace Update
	{
		typedef enum UpdateCallBackType {
			UPDATE_CALLBACK_BEGIN = 0,
			UPDATE_CALLBACK_DISPLAY_MSG,
			UPDATE_CALLBACK_DISPLAY_PERCENT,
			UPDATE_CALLBACK_DISPLAY_MENU,
			UPDATE_CALLBACK_GET_INPUT,
			UPDATE_CALLBACK_DISPLAY_PROMPT,
			UPDATE_CALLBACK_SELECT_PROMPT,
			UPDATE_CALLBACK_GET_FRUFIELD,
			UPDATE_CALLBACK_END
		} UpdateCallBackType;

		//Structure to store the MenuTitle and Menu Options from CFG File
#define MAX_MENU_LENGTH 1024
#define MAX_NUMBER_OF_MENU_OPTIONS 50

		typedef struct _CFG_MENU_TAG
		{
			char Menu_Title[MAX_MENU_LENGTH];
			char MenuOptions[MAX_NUMBER_OF_MENU_OPTIONS][MAX_MENU_LENGTH];
			int MaxMenu;
		}CFG_MENU_TAG;

		typedef struct _CFG_CALLBACK_CONTAINER
		{
			CFG_MENU_TAG sCfgMenu;
			WCHAR *wcDisplayMsg;
			bool bExitUpdate;
			WCHAR *wcUserInput;

			_CFG_CALLBACK_CONTAINER() {
				memset(&sCfgMenu, 0, sizeof(CFG_MENU_TAG));
				wcDisplayMsg = NULL;
				wcUserInput = NULL;
				bExitUpdate = false;
			};

		}CFG_CALLBACK_CONTAINER;


		typedef class UpdateCallBackBase {
		public:
			UpdateCallBackBase () {}
			//implement this virtual function to get the progress update of FW and BIOS update
			virtual void updateCallBack(UpdateCallBackType cbType, const WCHAR*, const UINTN, const UINTN){
			} 

			//implement this virtual function to add the callback function to parse CFG file
			virtual void updateCallBack(UpdateCallBackType cbType, CFG_CALLBACK_CONTAINER *sCfgCallbackData) {
			}

		private:

		} UpdateCallBackBase;

	}/* end of namespace Update */

} /* end of namespace Module */

#endif /* __UPDATECALLBACKBASE_H_ */
