/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/

#ifndef _CACHERIVER_CAPSULE_INT_FILE_H_
#define _CACHERIVER_CAPSULE_INT_FILE_H_

#include <os/include/cr_osal.h>
#include <modules/bmc/update/UpdateCallBackBase.h>

namespace Module
{
	namespace FileParser
	{
		
		typedef enum BiosUpdateOptions
		{
			BIOS_UPDATE_START = 1,
			BIOS_UPDATE_SHOW_VERSION = (1<<2),
			BIOS_UPDATE_DIRECT_UPDATE = (1<<3),
			BIOS_UPDATE_NO_PLATFORM_CHECK = (1<<4),
			BIOS_UPDATE_NO_DOWN_REVISION = (1<<5),
			BIOS_UPDATE_RESTORE_DEFAULT = (1<<6)
		}BiosUpdateOptions;

        typedef class CapsuleFileInt {
        public:

            CapsuleFileInt(STRING fileName, 
                        UINT32 bios_update_flags = BIOS_UPDATE_START) 
            {
                capsuleFileName = fileName;
                flags = bios_update_flags;
				ptrCallBackBase = NULL;
            }

            STRING getCapsuleFileName(void) {return capsuleFileName; }
            UINT32 getBiosUpdateFlags(void) {return flags; }
			void setCallBackClass(Module::Update::UpdateCallBackBase* ptrCallBackBase) {this->ptrCallBackBase = ptrCallBackBase;}
            Module::Update::UpdateCallBackBase* getCallBackClass(void) const { return this->ptrCallBackBase; }

        private:
             STRING capsuleFileName;
             UINT32 flags;
             Module::Update::UpdateCallBackBase* ptrCallBackBase;
        }CapsuleFileInt;
	
    }//end of namespace FileParser
}//end of namespace Module

#endif //_CACHERIVER_CAPSULE_INT_FILE_H_
