	/******************************************************************************
	*
	*                   INTEL CORPORATION PROPRIETARY INFORMATION
	*       This software is supplied under the terms of a license agreement or
	*       nondisclosure agreement with Intel Corporation and may not be copied
	*       or disclosed except in accordance with the terms of that agreement.
	*
	*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
	*
	*       All rights reserved.  No part of this program or publication may be
	*       reproduced, transmitted, transcribed, stored in a retrieval system,
	*       or translated into any language or computer language, in any form or
	*       by any means, electronic, mechanical, magnetic, optical, chemical,
	*       manual, or otherwise, without the prior written permission of Intel
	*       Corporation.
	*
	*
	*******************************************************************************/
#ifndef _CACHERIVER_FRU_FILE_H_
#define _CACHERIVER_FRU_FILE_H_

#include <os/include/cr_osal.h>
#include <modules/bmc/update/FRUSDR_File.h>
#include <modules/bmc/update/UpdateCallBackBase.h>

#include <iostream>

namespace Module
{
	namespace Update
	{
		class CLASSINDLL_CLASS_DECL FRUFile
		{
			public:
				FRUFile (const char * fruFileName);
				~FRUFile ();

				void setflags(bool display, bool fru, bool sdr, bool cfg, STRING devId="0", STRING devAddr="20")
				{
					flags.cfg=cfg;
					flags.display=display;
					flags.fru=fru;
					flags.sdr=sdr;
					flags.devId = devId;
					flags.devAddr = devAddr;
				}

			public:
				FILE * GetFile();
				const char * GetFileName();
				FRUSDRUpdateOptions flags;
				void setCallBackPtr(Module::Update::UpdateCallBackBase* _ptrCallBackBase) {ptrCallBackBase = _ptrCallBackBase;}
				Module::Update::UpdateCallBackBase* getCallBackPtr() { return ptrCallBackBase;}


			private:
				Module::Update::UpdateCallBackBase* ptrCallBackBase;
				FILE * mpFile;
				const char * mpFileName;
				

		};
	}
}

#endif// _CACHERIVER_FRU_FILE_H_
