/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef _common_errormgr_h_
#define _common_errormgr_h_

#include <os/include/cr_osal.h>
#include <common/errorcodes.h>

#define GET_ERROR_MSG(eCode) \
					ErrorManager::ErrorMgr::GetInstance()->Get(eCode)

namespace ErrorManager
{
	class CLASSINDLL_CLASS_DECL ErrorMgr
	{
		private:
			ErrorMgr();

		public:
			~ErrorMgr();

		public:
			static ErrorMgr * GetInstance();
			void CreateErrorMap();
			std::string Get(int eCode);

		public:
			ErrorStringMap mErrorStringMap;
			static ErrorMgr * m_pErrorMgr;
	};
}

//Selector Error Codes
///	Defines 16 bit IDs for various Cache River Selector Components.

enum SelectorError //always define 16 bit codes
{
	SelectorErr_NoCreatInfo		= 0x01,
	SelectorErr_NoDll		= 0x02,
	SelectorErr_NoProc		= 0x03,
	SelectorErr_InvalidGetObj 	= 0x04,
	SelectorErr_GetObjFailed	= 0x05
};

//SMI Driver Error Codes
///	Defines 16 bit IDs for various Cache River SMI Driver Components.

enum SMIDriverError
{

};

//Mem Driver Error Codes
///	Defines 16 bit IDs for various Cache River MemMap Components.

enum MemMapDriverError
{
	MemMapDrvErr_BadAlloc		= 0x01,
	MemMapDrvErr_LockFailed		= 0x02,
	MemMapDrvErr_v2pFailed		= 0x03,
	MemMapDrvErr_mmapFailed		= 0x04,
	MemMapDrvErr_dev_mem_failed	= 0x05,
	MemMapDrvErr_dev_mem_driver_failed= 0x06
};

//SMBIOS Error Codes
///	Defines 16 bit IDs for various Cache River SMBIOS Components.

enum SMBIOSProtocolError
{
	SMBIOProtocolErr_MemMapDrvErr_mmapFailed  = 0x01,
	SMBIOProtocolErr_GetSMBIOS_EntryPtrFailed =0x02,
	SMBIOProtocolErr_TypeNotPresent =0x03,
	SMBIOProtocolErr_InstanceNotPresent = 0x04,
	SMBIOProtocolErr_SubTypeNotPresent = 0x05,
	SMBIOProtocolErr_InvalidHandle = 0x06,
	SMBIOProtocolErr_FieldNameNotPresent = 0x07,
	SMBIOProtocolErr_FieldNameCantInterpret = 0x08
};

//SMI Error Codes
///	Defines 16 bit IDs for various Cache River SMI Protocol Components.

enum SMIProtocolError
{
        SMIProtocolErr_ALLOC_MEMORY_STRINGS = 0x01,
		SMIProtocolErr_MEM_ALLOC_FAILED = 0x02,
		SMIProtocolErr_GET_VAR_FAILED = 0x03,
		SMIProtocolErr_GET_NEXT_VAR_FAILED = 0x04,
		SMIProtocolErr_SET_VAR_FAILED = 0x05,
		SMIProtocolErr_GET_HII_FAILED = 0x06,
		SMIProtocolErr_INITIALIZE = 0x07,
		SMIProtocolErr_DEINITIALIZE = 0x08,
		SMIProtocolErr_INVALID_DATA_WIDTH = 0x09

};

//HII Error Codes
///	Defines 16 bit IDs for various Cache River HII Components.

enum HIIProtocolError
{
        HIIProtocolErr_HIIBaseAddress  = 0x01,
        HIIProtocolErr_GetVariable  = 0x02

};

enum XDirectorError
{
	XDirectorErr_NoOfParameterNotValid  = 0x01,
	XDirectorErr_FirstParameterInvalid  = 0x02,
	XDirectorErr_ParameterIsNotAlphaNumeric = 0x03,
	XDirectorErr_TypeInvalid = 0x04,
	XDirectorErr_SecondParameterInvalid = 0x06,
	XDirectorErr_SubscriptInvalid = 0x07,
	XDirectorErr_ParameterEmpty = 0x08,
	XDirectorErr_InvalidQuery = 0x09
};

enum BIOSConfigError
{
	BIOSConfigError_InvalidQuery = 0x01,
	BIOSConfigError_InvalidSettingValue = 0x02,
	BIOSConfigError_ReadOnlySetting = 0x3
};

#endif
