/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef __CR_DEFAULT_FUNCTORS_H_
#define __CR_DEFAULT_FUNCTORS_H_

#include <stdlib.h>
#include <string.h>

namespace osal_stl {

    /* unary functor definition */
    template<typename arg, typename res>
    struct unary_function
    {
        typedef     arg     argument_type;
        typedef     res     result_type;
    };

    /* binary functor definition */
    template<typename arg1, typename arg2, typename res>
    struct binary_function
    {
        typedef arg1 first_argument_type;
        typedef arg2 second_argument_type;
        typedef res  result_type;
    };

    /* binary plus functor definition */
    template<typename T>
    struct cr_plus : public binary_function<T, T, T>
    {
        T
        operator() (const T& x, const T& y) const
        { return (x + y); }
    };

    /* binary minus functor definition */
    template<typename T>
    struct cr_minus : public binary_function<T, T, T>
    {
        T
        operator() (const T& x, const T& y) const
        { return (x - y); }
    };

    /* binary multiply functor definition */
    template<typename T>
    struct cr_multiplies : public binary_function<T, T, T>
    {
        T
        operator() (const T& x, const T& y) const
        { return (x * y); }
    };

    /* binary divides functor definition */
    template<typename T>
    struct cr_divides : public binary_function<T, T, T>
    {
        T
        operator() (const T& x, const T& y) const
        { return (x / y); }
    };

    /* binary modulus functor definition */
    template<typename T>
    struct cr_modulus : public binary_function<T, T, T>
    {
        T
        operator() (const T& x, const T& y) const
        { return (x % y); }
    };

    /* unary negate functor definition */
    template<typename T>
    struct cr_negate : public unary_function<T, T>
    {
        T
        operator() (const T& x) const
        { return -x; }
    };

    /* binary comparator == functor */
    template<typename E> struct cr_equal_to : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x == y); }
    };

    /* binary comparator != functor */
    template<typename E> struct cr_not_equal_to : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x != y); }
    };

    /* binary comparator > functor */
    template<typename E> struct cr_greater : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x > y); }
    };

    /* binary comparator < functor */
    template<typename E> struct cr_less : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x < y); }
    };

    /* binary comparator >= functor */
    template<typename E> struct cr_greater_equal : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x >= y); }
    };

    /* binary comparator <= functor */
    template<typename E> struct cr_less_equal : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x <= y); }
    };

    /* binary logical and (&&) functor */
    template<typename E> struct cr_logical_and : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x && y); }
    };

    /* binary logical or (|| functor */
    template<typename E> struct cr_logical_or : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x || y); }
    };

    /* unary logical not (!) functor */
    template<typename E> struct cr_logical_not : public unary_function<E, bool> 
    {
        bool
        operator()(const E& x) const
        { return !x; }
    };

    /* binary bit and (&) functor */
    template<typename E> struct cr_bit_and : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x & y); }
    };

    /* binary bit or (|) functor */
    template<typename E> struct cr_bit_or : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x | y); }
    };

    /* binary bit xor (|) functor */
    template<typename E> struct cr_bit_xor : public binary_function<E, E, bool> 
    {
        bool
        operator()(const E& x, const E& y) const
        { return (x ^ y); }
    };

    /* equal_to specialization for char* */
    template<>
    struct cr_equal_to<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) == 0);
        }
    };
 
    /* equal_to specialization for const char* */
    template<>
    struct cr_equal_to<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) == 0);
        }
    };

    /* not_equal_to specialization for char* */
    template<>
    struct cr_not_equal_to<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) != 0);
        }
    };
 
    /* not_equal_to specialization for const char* */
    template<>
    struct cr_not_equal_to<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) != 0);
        }
    };

    /* less specialization for char* */
    template<>
    struct cr_less<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) < 0);
        }
    };
 
    /* less specialization for const char* */
    template<>
    struct cr_less<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) < 0);
        }
    };

    /* greater specialization for char* */
    template<>
    struct cr_greater<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) > 0);
        }
    };
 
    /* greater specialization for const char* */
    template<>
    struct cr_greater<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) > 0);
        }
    };

    /* less_equal specialization for char* */
    template<>
    struct cr_less_equal<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) <= 0);
        }
    };
 
    /* less_equal specialization for const char* */
    template<>
    struct cr_less_equal<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) <= 0);
        }
    };

    /* greater_equal specialization for char* */
    template<>
    struct cr_greater_equal<char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) >= 0);
        }
    };
 
    /* greater_equal specialization for const char* */
    template<>
    struct cr_greater_equal<const char*>
    {
        bool
        operator()(const char* ch1, const char* ch2) const
        {
            return (strcmp(ch1, ch2) >= 0);
        }
    };

    /* hash function object definition */
    template<class Key> struct cr_hash { };

    inline size_t
    _cr_hash_string(const char* ch)
    {
        size_t hash = 0;

        for (; *ch!='\0'; *ch++)
        {
            hash += ((size_t)(*ch) + 0x7ed55d16) + ((size_t)(*ch)<<12); 
#if 0
            hash ^= ((size_t)(hash)^0xc761c23c) ^ ((size_t)(hash)>>19); 
            hash += ((size_t)(hash)+0x165667b1) + ((size_t)(hash)<<5); 
            hash += ((size_t)(hash)+0xd3a2646c) ^ ((size_t)(hash)<<9); 
            hash += ((size_t)(hash)+0xfd7046c5) + ((size_t)(hash)<<3); 
            hash += ((size_t)(hash)^0xb55a4f09) + ((size_t)(hash)>>16); 
#endif
        }

        return hash;
    }
    
    /* cr_hash specialization for char */
    template<>
    struct cr_hash<char>
    {
        size_t
        operator()(const char ch) const
        {
            return size_t(ch);
        }
    };
     
    /* cr_hash specialization for const char */
    template<>
    struct cr_hash<const char>
    {
        size_t
        operator()(const char ch) const
        {
            return size_t(ch);
        }
    };
      
    /* cr_hash specialization for int */
    template<>
    struct cr_hash<int>
    {
        size_t
        operator()(const int i) const
        {
            return size_t(i);
        }
    };
       
    /* cr_hash specialization for const int */
    template<>
    struct cr_hash<const int>
    {
        size_t
        operator()(const int i) const
        {
            return size_t(i);
        }
    };
 
 
    /* cr_hash specialization for char* */
    template<>
    struct cr_hash<char*>
    {
        size_t
        operator()(const char* ch) const
        {
            return _cr_hash_string(ch);
        }
    };
 
    /* cr_hash specialization for const char* */
    template<>
    struct cr_hash<const char*>
    {
        size_t
        operator()(const char* ch) const
        {
            return _cr_hash_string(ch);
        }
    };

}//end of namespace osal_stl


#endif // __CR_DEFAULT_FUNCTORS_H_
