/******************************************************************************
*
*                   INTEL CORPORATION PROPRIETARY INFORMATION
*       This software is supplied under the terms of a license agreement or
*       nondisclosure agreement with Intel Corporation and may not be copied
*       or disclosed except in accordance with the terms of that agreement.
*
*            Copyright (c) 2008-2009 Intel Corporation. All Rights Reserved.
*
*       All rights reserved.  No part of this program or publication may be
*       reproduced, transmitted, transcribed, stored in a retrieval system,
*       or translated into any language or computer language, in any form or
*       by any means, electronic, mechanical, magnetic, optical, chemical,
*       manual, or otherwise, without the prior written permission of Intel
*       Corporation.
*
*
*******************************************************************************/
#ifndef _common_exception_h_
#define _common_exception_h_

#include <stdio.h>
#include <os/include/cr_osal.h>
#include <common/errormgr.h>
//#include <modules/XDirectorImpl.h>

// objRS - Object name to be created if _EFI_ is not defined else create a structure of type objRS
// x - first parameter - ComponentID
// y - second parameter - ErrorCode
// z - third parameter - ErrorString
//#define STATUS_SUCCESS	0
typedef enum 
{
	// -----------------------------------
	// common error codes
	// -----------------------------------
	STATUS_SUCCESS = 0,
	STATUS_FAILURE,
	STATUS_NOT_SUPPORTED,
	STATUS_API_NOT_INITIALIZED,
	STATUS_INVALID_ARGUMENTS,
	STATUS_MEM_ALLOC_FAILED,
	STATUS_BMC_COMMN_FAILED,
	STATUS_MEM_NOT_SUFFICIENT,
	STATUS_PARAMETER_NOT_SUPPORTED,
	STATUS_SDR_NOT_FOUND,
	STATUS_EVENTS_DISABLED,
	// -----------------------------------
	// Processor API specific error codes
	// -----------------------------------
	STATUS_INCORRECT_PROCESSOR_ID ,
	STATUS_INVALID_MSR_ADDRESS,
	STATUS_DRIVER_NOT_FUNCTIONING,
	STATUS_MEM_OUT_OF_RANGE,
	STATUS_WAIT_TIMEOUT, //added for Processor support
	STATUS_FRU_DECODER_CHASSIS_AREA_ABSENT,
	STATUS_FRU_DECODER_BOARD_AREA_ABSENT,
	STATUS_FRU_DECODER_PRODUCT_AREA_ABSENT,
	STATUS_MULTIRECORD_TYPE_NOT_SUPPORTED,
	STATUS_SYSTEM_NOT_SUPPORTED,
	STATUS_USER_CONFIG_NOT_SUPPORTED,
	STATUS_PARAMETER_NOT_AVAILABLE,
	STATUS_NO_WRITE_ACCESS,
	STATUS_NO_READ_ACCESS,
	STATUS_INSUFFICIENT_RESOURCES,
	STATUS_INVALID_SESSION_ID

} API_STATUS;


#ifndef _EFI_
#define TRY 			try
#define CATCH(objRS) 		catch(ResultStatus objRS)
#define THROW(objRS)	 	throw(objRS)
#define RSTATUS 		const STATUSLIST&
//#define CREATE(objRS,x,y,z) ResultStatus objRS(x,y,z)
#ifdef CR_WINDOWS
#define CREATE_RS(objRS,xQuery,xCmd,eCode,...) \
						std::string source = GET_ERROR_MSG(eCode);\
						std::string target;\
						CREATEMSG(target,source, __VA_ARGS__);\
						DLOG(debug, "%d: %s", eCode, target.c_str()); \
						RLOG(error, "%d: %s", eCode, target.c_str()); \
						ResultStatus objRS(eCode,target,xQuery,xCmd)

#else //for CR_LINUX
#define CREATE_RS(objRS,xQuery,xCmd,eCode,...) \
						std::string source = GET_ERROR_MSG(eCode);\
						std::string target;\
						CREATEMSG(target,source, ## __VA_ARGS__);\
						DLOG(debug, "%d: %s", eCode, target.c_str()); \
						RLOG(error, "%d: %s", eCode, target.c_str()); \
						ResultStatus objRS(eCode,target,xQuery,xCmd)
#endif

#ifdef CR_WINDOWS
#define INSERT_RS(objRS,xQuery,xCmd,eCode,...) \
						std::string source = GET_ERROR_MSG(eCode);\
						std::string target;\
						CREATEMSG(target,source, __VA_ARGS__);\
						DLOG(debug, "%d: %s", eCode, target.c_str()); \
						objRS.Insert(RStatus(eCode,target,xQuery,xCmd))
#else //for CR_LINUX
#define INSERT_RS(objRS,xQuery,xCmd,eCode,...) \
						std::string source = GET_ERROR_MSG(eCode);\
						std::string target;\
						CREATEMSG(target,source, ##  __VA_ARGS__);\
						DLOG(debug, "%d: %s", eCode, target.c_str()); \
						objRS.Insert(RStatus(eCode,target,xQuery,xCmd))
#endif

//#define INSERT(objRS,x,y,z)	objRS.Insert(RStatus(x,y,z))
#else
#define TRY
#define CATCH(objRS)
#define THROW(objRS) 		return(objRS)
#define RSTATUS			const RStatus&
//#define CREATE(objRS,x,y,z) RStatus objRS(x,y,z)

#define CREATE_RS(objRS,xQuery,xCmd,eCode,...) \
						std::string source = GET_ERROR_MSG(eCode);\
						std::string target;\
						CREATEMSG(target,source, ## __VA_ARGS__);\
						DLOG(debug, "%d: %s", eCode, target.c_str()); \
						RLOG(debug, "%d: %s", eCode, target.c_str()); \
						ResultStatus objRS(eCode,target,xQuery,xCmd)

//#define INSERT(objRS,x,y,z)	RStatus objRS(x,y,z)
#define INSERT_RS(objRS,a,b,y,z) RStatus objRS(y,z,a,b)
#endif

typedef enum _XCOMMAND
{
	COMMAND_GET = 0,
	COMMAND_SET,
	COMMAND_UNKNOWN
} XCOMMAND;

struct RStatus
{
	UINT16 mComponent;
	UINT16 mErrorCode;
	std::string mErrorString;
	std::string mXQuery;
	XCOMMAND mCommand;
	RStatus(UINT16 Component,UINT16 ErrorCode, std::string ErrorString) :
		mComponent(Component),mErrorCode(ErrorCode),mErrorString(ErrorString)
	{
	}

	RStatus(UINT16 ErrorCode, std::string ErrorString, std::string xQuery = "", XCOMMAND xCmd = COMMAND_UNKNOWN)
		: mErrorCode(ErrorCode),mErrorString(ErrorString), mXQuery(xQuery), mCommand (xCmd)
	{
	}
};

typedef vector<RStatus> STATUSLIST;

/*!
	ResultStatus class defines the generic exception type for the exceptions thrown by cache river.
*/
class CLASSINDLL_CLASS_DECL ResultStatus// : public std::exception
{
public:
	ResultStatus(UINT16 Component,UINT16 ErrorCode,std::string ErrorString);
	ResultStatus(UINT16 ErrorCode, std::string ErrorString, std::string xQuery = "", XCOMMAND xCmd = COMMAND_UNKNOWN);
	~ResultStatus();

public:
	ResultStatus(const ResultStatus &rs);

public:
	void Insert(RStatus);
	RSTATUS Get()const;

public:
	//Status mStatus;

private:
	//vector<Status> mResultStatusList;
	STATUSLIST		 mResultStatusList;

private:
	ResultStatus();
	ResultStatus & operator = (const ResultStatus&);
};

#endif

/*! \}
	\}
*/
