# Copyright (c) 2015, Intel Corporation
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
#     * Redistributions of source code must retain the above copyright notice,
#       this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright notice,
#       this list of conditions and the following disclaimer in the documentation
#       and/or other materials provided with the distribution.
#     * Neither the name of Intel Corporation nor the names of its contributors
#       may be used to endorse or promote products derived from this software
#       without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
# ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

"""efikeys: EFI key constants"""
# Defined here to avoid an import loop between efi and bits.input

KEY_UP        = 0x01
KEY_DOWN      = 0x02
KEY_RIGHT     = 0x03
KEY_LEFT      = 0x04
KEY_HOME      = 0x05
KEY_END       = 0x06
KEY_INS       = 0x07
KEY_INSERT    = 0x07
KEY_DEL       = 0x08
KEY_DELETE    = 0x08
KEY_PGUP      = 0x09
KEY_PAGE_UP   = 0x09
KEY_PGDN      = 0x0a
KEY_PAGE_DOWN = 0x0a
KEY_F1        = 0x0b
KEY_F2        = 0x0c
KEY_F3        = 0x0d
KEY_F4        = 0x0e
KEY_F5        = 0x0f
KEY_F6        = 0x10
KEY_F7        = 0x11
KEY_F8        = 0x12
KEY_F9        = 0x13
KEY_F10       = 0x14
KEY_F11       = 0x15
KEY_F12       = 0x16
KEY_ESC       = 0x17
